/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.function;

import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.dataflow.DoubleFlowFunction;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.IntFlowFunction;
import com.fluxtion.runtime.dataflow.LongFlowFunction;
import com.fluxtion.runtime.dataflow.function.AbstractFlowFunction;
import com.fluxtion.runtime.partition.LambdaReflection;

public class FilterFlowFunction<T, S extends FlowFunction<T>>
extends AbstractFlowFunction<T, T, S> {
    final LambdaReflection.SerializableFunction<T, Boolean> filterFunction;
    final transient String auditInfo;

    public FilterFlowFunction(S inputEventStream, LambdaReflection.SerializableFunction<T, Boolean> filterFunction) {
        super(inputEventStream, filterFunction);
        this.filterFunction = filterFunction;
        this.auditInfo = filterFunction.method().getDeclaringClass().getSimpleName() + "->" + filterFunction.method().getName();
    }

    @OnTrigger
    public boolean filter() {
        boolean filter = this.isPublishTriggered() || (Boolean)this.filterFunction.apply(this.getInputEventStream().get()) != false;
        boolean fireNotification = filter & this.fireEventUpdateNotification();
        this.auditLog.info("filterFunction", this.auditInfo);
        this.auditLog.info("filterPass", filter);
        this.auditLog.info("publishToChild", fireNotification);
        return fireNotification;
    }

    @Override
    public T get() {
        return this.getInputEventStream().get();
    }

    public static class LongFilterFlowFunction
    extends AbstractFlowFunction<Long, Long, LongFlowFunction>
    implements LongFlowFunction {
        final LambdaReflection.SerializableLongFunction<Boolean> filterFunction;
        final transient String auditInfo;

        public LongFilterFlowFunction(LongFlowFunction inputEventStream, LambdaReflection.SerializableLongFunction<Boolean> filterFunction) {
            super(inputEventStream, filterFunction);
            this.filterFunction = filterFunction;
            this.auditInfo = filterFunction.method().getDeclaringClass().getSimpleName() + "->" + filterFunction.method().getName();
        }

        @OnTrigger
        public boolean filter() {
            boolean filter = this.isPublishTriggered() || (Boolean)this.filterFunction.apply(((LongFlowFunction)this.getInputEventStream()).getAsLong()) != false;
            boolean fireNotification = filter & this.fireEventUpdateNotification();
            this.auditLog.info("filterFunction", this.auditInfo);
            this.auditLog.info("filterPass", filter);
            this.auditLog.info("publishToChild", fireNotification);
            return fireNotification;
        }

        @Override
        public Long get() {
            return this.getAsLong();
        }

        @Override
        public long getAsLong() {
            return ((LongFlowFunction)this.getInputEventStream()).getAsLong();
        }
    }

    public static class DoubleFilterFlowFunction
    extends AbstractFlowFunction<Double, Double, DoubleFlowFunction>
    implements DoubleFlowFunction {
        final LambdaReflection.SerializableDoubleFunction<Boolean> filterFunction;
        final transient String auditInfo;

        public DoubleFilterFlowFunction(DoubleFlowFunction inputEventStream, LambdaReflection.SerializableDoubleFunction<Boolean> filterFunction) {
            super(inputEventStream, filterFunction);
            this.filterFunction = filterFunction;
            this.auditInfo = filterFunction.method().getDeclaringClass().getSimpleName() + "->" + filterFunction.method().getName();
        }

        @OnTrigger
        public boolean filter() {
            boolean filter = this.isPublishTriggered() || (Boolean)this.filterFunction.apply(((DoubleFlowFunction)this.getInputEventStream()).getAsDouble()) != false;
            boolean fireNotification = filter & this.fireEventUpdateNotification();
            this.auditLog.info("filterFunction", this.auditInfo);
            this.auditLog.info("filterPass", filter);
            this.auditLog.info("publishToChild", fireNotification);
            return fireNotification;
        }

        @Override
        public Double get() {
            return this.getAsDouble();
        }

        @Override
        public double getAsDouble() {
            return ((DoubleFlowFunction)this.getInputEventStream()).getAsDouble();
        }
    }

    public static class IntFilterFlowFunction
    extends AbstractFlowFunction<Integer, Integer, IntFlowFunction>
    implements IntFlowFunction {
        final LambdaReflection.SerializableIntFunction<Boolean> filterFunction;
        final transient String auditInfo;

        public IntFilterFlowFunction(IntFlowFunction inputEventStream, LambdaReflection.SerializableIntFunction<Boolean> filterFunction) {
            super(inputEventStream, filterFunction);
            this.filterFunction = filterFunction;
            this.auditInfo = filterFunction.method().getDeclaringClass().getSimpleName() + "->" + filterFunction.method().getName();
        }

        @OnTrigger
        public boolean filter() {
            boolean filter = this.isPublishTriggered() || (Boolean)this.filterFunction.apply(((IntFlowFunction)this.getInputEventStream()).getAsInt()) != false;
            boolean fireNotification = filter & this.fireEventUpdateNotification();
            this.auditLog.info("filterFunction", this.auditInfo);
            this.auditLog.info("filterPass", filter);
            this.auditLog.info("publishToChild", fireNotification);
            return fireNotification;
        }

        @Override
        public Integer get() {
            return this.getAsInt();
        }

        @Override
        public int getAsInt() {
            return ((IntFlowFunction)this.getInputEventStream()).getAsInt();
        }
    }
}

