/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.function;

import com.fluxtion.runtime.EventProcessorBuilderService;
import com.fluxtion.runtime.annotations.NoTriggerReference;
import com.fluxtion.runtime.annotations.OnParentUpdate;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.annotations.builder.Inject;
import com.fluxtion.runtime.audit.EventLogNode;
import com.fluxtion.runtime.callback.Callback;
import com.fluxtion.runtime.callback.DirtyStateMonitor;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.TriggeredFlowFunction;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.util.Arrays;
import java.util.List;

public class FlatMapArrayFlowFunction<T, R, S extends FlowFunction<T>>
extends EventLogNode
implements TriggeredFlowFunction<R> {
    @NoTriggerReference
    private final S inputEventStream;
    @NoTriggerReference
    private final transient Object streamFunctionInstance;
    @Inject
    public DirtyStateMonitor dirtyStateMonitor;
    private final LambdaReflection.SerializableFunction<T, R[]> iterableFunction;
    private transient R value;
    @Inject
    public Callback<R> callback;

    public FlatMapArrayFlowFunction(S inputEventStream, LambdaReflection.SerializableFunction<T, R[]> iterableFunction) {
        this.inputEventStream = inputEventStream;
        this.iterableFunction = iterableFunction;
        this.streamFunctionInstance = iterableFunction.captured().length > 0 ? EventProcessorBuilderService.service().addOrReuse(iterableFunction.captured()[0]) : null;
    }

    @OnParentUpdate(value="inputEventStream")
    public void inputUpdatedAndFlatMap(S inputEventStream) {
        Object input = inputEventStream.get();
        List<Object> iterable = Arrays.asList((Object[])this.iterableFunction.apply(input));
        this.callback.fireCallback(iterable.iterator());
    }

    @Override
    public void parallel() {
    }

    @Override
    public boolean parallelCandidate() {
        return false;
    }

    @Override
    public boolean hasChanged() {
        return this.dirtyStateMonitor.isDirty(this);
    }

    @OnTrigger
    public void callbackReceived() {
        this.value = this.callback.get();
    }

    @Override
    public R get() {
        return this.value;
    }

    @Override
    public void setUpdateTriggerNode(Object updateTriggerNode) {
    }

    @Override
    public void setPublishTriggerNode(Object publishTriggerNode) {
    }

    @Override
    public void setResetTriggerNode(Object resetTriggerNode) {
    }

    @Override
    public void setPublishTriggerOverrideNode(Object publishTriggerOverrideNode) {
    }
}

