/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.function;

import com.fluxtion.runtime.annotations.NoTriggerReference;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.dataflow.DefaultValueSupplier;
import com.fluxtion.runtime.dataflow.DoubleFlowFunction;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.IntFlowFunction;
import com.fluxtion.runtime.dataflow.LongFlowFunction;
import com.fluxtion.runtime.dataflow.function.AbstractFlowFunction;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.lang.reflect.Method;

public abstract class MapFlowFunction<T, R, S extends FlowFunction<T>>
extends AbstractFlowFunction<T, R, S> {
    protected transient String auditInfo;
    protected transient R result;

    public MapFlowFunction(S inputEventStream, LambdaReflection.MethodReferenceReflection methodReferenceReflection) {
        super(inputEventStream, methodReferenceReflection);
        if (methodReferenceReflection != null) {
            Method method = methodReferenceReflection.method();
            this.auditInfo = method.getDeclaringClass().getSimpleName() + "->" + method.getName();
        }
    }

    @OnTrigger
    public final boolean map() {
        this.auditLog.info("mapFunction", this.auditInfo);
        if (this.executeUpdate()) {
            this.auditLog.info("invokeMapFunction", true);
            this.mapOperation();
        } else if (this.reset()) {
            this.auditLog.info("invokeMapFunction", false);
            this.auditLog.info("reset", true);
        } else {
            this.auditLog.info("invokeMapFunction", false);
        }
        return this.fireEventUpdateNotification();
    }

    @Override
    protected void initialise() {
        Method method = this.getStreamFunction().method();
        if (DefaultValueSupplier.class.isAssignableFrom(method.getDeclaringClass())) {
            this.mapOperation();
        }
    }

    @Override
    public boolean hasDefaultValue() {
        return DefaultValueSupplier.class.isAssignableFrom(this.getStreamFunction().method().getDeclaringClass());
    }

    @Override
    public R get() {
        return this.result;
    }

    protected abstract void mapOperation();

    @Override
    protected void resetOperation() {
        this.result = this.resetFunction.reset();
    }

    public static class MapDouble2ToLongFlowFunction
    extends AbstractMapToLongFlowFunction<Double, DoubleFlowFunction> {
        private final LambdaReflection.SerializableDoubleToLongFunction intUnaryOperator;

        public MapDouble2ToLongFlowFunction(DoubleFlowFunction inputEventStream, LambdaReflection.SerializableDoubleToLongFunction intUnaryOperator) {
            super(inputEventStream, intUnaryOperator);
            this.intUnaryOperator = intUnaryOperator;
        }

        @Override
        protected void mapOperation() {
            this.result = this.intUnaryOperator.applyAsLong(((DoubleFlowFunction)this.getInputEventStream()).getAsDouble());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapDouble2ToLongFlowFunction)) {
                return false;
            }
            MapDouble2ToLongFlowFunction other = (MapDouble2ToLongFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableDoubleToLongFunction this$intUnaryOperator = this.intUnaryOperator;
            LambdaReflection.SerializableDoubleToLongFunction other$intUnaryOperator = other.intUnaryOperator;
            return !(this$intUnaryOperator == null ? other$intUnaryOperator != null : !this$intUnaryOperator.equals(other$intUnaryOperator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapDouble2ToLongFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableDoubleToLongFunction $intUnaryOperator = this.intUnaryOperator;
            result = result * 59 + ($intUnaryOperator == null ? 43 : $intUnaryOperator.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MapFlowFunction.MapDouble2ToLongFlowFunction(intUnaryOperator=" + this.intUnaryOperator + ")";
        }
    }

    public static class MapInt2ToLongFlowFunction
    extends AbstractMapToLongFlowFunction<Integer, IntFlowFunction> {
        private final LambdaReflection.SerializableIntToLongFunction intUnaryOperator;

        public MapInt2ToLongFlowFunction(IntFlowFunction inputEventStream, LambdaReflection.SerializableIntToLongFunction intUnaryOperator) {
            super(inputEventStream, intUnaryOperator);
            this.intUnaryOperator = intUnaryOperator;
        }

        @Override
        protected void mapOperation() {
            this.result = this.intUnaryOperator.applyAsLong(((IntFlowFunction)this.getInputEventStream()).getAsInt());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapInt2ToLongFlowFunction)) {
                return false;
            }
            MapInt2ToLongFlowFunction other = (MapInt2ToLongFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableIntToLongFunction this$intUnaryOperator = this.intUnaryOperator;
            LambdaReflection.SerializableIntToLongFunction other$intUnaryOperator = other.intUnaryOperator;
            return !(this$intUnaryOperator == null ? other$intUnaryOperator != null : !this$intUnaryOperator.equals(other$intUnaryOperator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapInt2ToLongFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableIntToLongFunction $intUnaryOperator = this.intUnaryOperator;
            result = result * 59 + ($intUnaryOperator == null ? 43 : $intUnaryOperator.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MapFlowFunction.MapInt2ToLongFlowFunction(intUnaryOperator=" + this.intUnaryOperator + ")";
        }
    }

    public static class MapLong2ToLongFlowFunction
    extends AbstractMapToLongFlowFunction<Long, LongFlowFunction> {
        private final LambdaReflection.SerializableLongUnaryOperator intUnaryOperator;

        public MapLong2ToLongFlowFunction(LongFlowFunction inputEventStream, LambdaReflection.SerializableLongUnaryOperator intUnaryOperator) {
            super(inputEventStream, intUnaryOperator);
            this.intUnaryOperator = intUnaryOperator;
        }

        @Override
        protected void mapOperation() {
            this.result = this.intUnaryOperator.applyAsLong(((LongFlowFunction)this.getInputEventStream()).getAsLong());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapLong2ToLongFlowFunction)) {
                return false;
            }
            MapLong2ToLongFlowFunction other = (MapLong2ToLongFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableLongUnaryOperator this$intUnaryOperator = this.intUnaryOperator;
            LambdaReflection.SerializableLongUnaryOperator other$intUnaryOperator = other.intUnaryOperator;
            return !(this$intUnaryOperator == null ? other$intUnaryOperator != null : !this$intUnaryOperator.equals(other$intUnaryOperator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapLong2ToLongFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableLongUnaryOperator $intUnaryOperator = this.intUnaryOperator;
            result = result * 59 + ($intUnaryOperator == null ? 43 : $intUnaryOperator.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MapFlowFunction.MapLong2ToLongFlowFunction(intUnaryOperator=" + this.intUnaryOperator + ")";
        }
    }

    public static class MapRef2ToLongFlowFunction<R, S extends FlowFunction<R>>
    extends AbstractMapToLongFlowFunction<R, S> {
        private final LambdaReflection.SerializableToLongFunction<R> intUnaryOperator;

        public MapRef2ToLongFlowFunction(S inputEventStream, LambdaReflection.SerializableToLongFunction<R> intUnaryOperator) {
            super(inputEventStream, intUnaryOperator);
            this.intUnaryOperator = intUnaryOperator;
        }

        @Override
        protected void mapOperation() {
            this.result = this.intUnaryOperator.applyAsLong(this.getInputEventStream().get());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapRef2ToLongFlowFunction)) {
                return false;
            }
            MapRef2ToLongFlowFunction other = (MapRef2ToLongFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableToLongFunction<R> this$intUnaryOperator = this.intUnaryOperator;
            LambdaReflection.SerializableToLongFunction<R> other$intUnaryOperator = other.intUnaryOperator;
            return !(this$intUnaryOperator == null ? other$intUnaryOperator != null : !this$intUnaryOperator.equals(other$intUnaryOperator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapRef2ToLongFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableToLongFunction<R> $intUnaryOperator = this.intUnaryOperator;
            result = result * 59 + ($intUnaryOperator == null ? 43 : $intUnaryOperator.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MapFlowFunction.MapRef2ToLongFlowFunction(intUnaryOperator=" + this.intUnaryOperator + ")";
        }
    }

    static abstract class AbstractMapToLongFlowFunction<T, S extends FlowFunction<T>>
    extends MapFlowFunction<T, Long, S>
    implements LongFlowFunction {
        protected transient long result;

        public AbstractMapToLongFlowFunction(S inputEventStream, LambdaReflection.MethodReferenceReflection method) {
            super(inputEventStream, method);
        }

        @Override
        protected void resetOperation() {
            this.result = (Long)this.resetFunction.reset();
        }

        @Override
        public Long get() {
            return this.getAsLong();
        }

        @Override
        public long getAsLong() {
            return this.result;
        }
    }

    public static class MapLong2ToDoubleFlowFunction
    extends AbstractMapToDoubleFlowFunction<Long, LongFlowFunction> {
        private final LambdaReflection.SerializableLongToDoubleFunction intUnaryOperator;

        public MapLong2ToDoubleFlowFunction(LongFlowFunction inputEventStream, LambdaReflection.SerializableLongToDoubleFunction intUnaryOperator) {
            super(inputEventStream, intUnaryOperator);
            this.intUnaryOperator = intUnaryOperator;
        }

        @Override
        protected void mapOperation() {
            this.result = this.intUnaryOperator.applyAsDouble(((LongFlowFunction)this.getInputEventStream()).getAsLong());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapLong2ToDoubleFlowFunction)) {
                return false;
            }
            MapLong2ToDoubleFlowFunction other = (MapLong2ToDoubleFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableLongToDoubleFunction this$intUnaryOperator = this.intUnaryOperator;
            LambdaReflection.SerializableLongToDoubleFunction other$intUnaryOperator = other.intUnaryOperator;
            return !(this$intUnaryOperator == null ? other$intUnaryOperator != null : !this$intUnaryOperator.equals(other$intUnaryOperator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapLong2ToDoubleFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableLongToDoubleFunction $intUnaryOperator = this.intUnaryOperator;
            result = result * 59 + ($intUnaryOperator == null ? 43 : $intUnaryOperator.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MapFlowFunction.MapLong2ToDoubleFlowFunction(intUnaryOperator=" + this.intUnaryOperator + ")";
        }
    }

    public static class MapInt2ToDoubleFlowFunction
    extends AbstractMapToDoubleFlowFunction<Integer, IntFlowFunction> {
        private final LambdaReflection.SerializableIntToDoubleFunction intUnaryOperator;

        public MapInt2ToDoubleFlowFunction(IntFlowFunction inputEventStream, LambdaReflection.SerializableIntToDoubleFunction intUnaryOperator) {
            super(inputEventStream, intUnaryOperator);
            this.intUnaryOperator = intUnaryOperator;
        }

        @Override
        protected void mapOperation() {
            this.result = this.intUnaryOperator.applyAsDouble(((IntFlowFunction)this.getInputEventStream()).getAsInt());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapInt2ToDoubleFlowFunction)) {
                return false;
            }
            MapInt2ToDoubleFlowFunction other = (MapInt2ToDoubleFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableIntToDoubleFunction this$intUnaryOperator = this.intUnaryOperator;
            LambdaReflection.SerializableIntToDoubleFunction other$intUnaryOperator = other.intUnaryOperator;
            return !(this$intUnaryOperator == null ? other$intUnaryOperator != null : !this$intUnaryOperator.equals(other$intUnaryOperator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapInt2ToDoubleFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableIntToDoubleFunction $intUnaryOperator = this.intUnaryOperator;
            result = result * 59 + ($intUnaryOperator == null ? 43 : $intUnaryOperator.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MapFlowFunction.MapInt2ToDoubleFlowFunction(intUnaryOperator=" + this.intUnaryOperator + ")";
        }
    }

    public static class MapDouble2ToDoubleFlowFunction
    extends AbstractMapToDoubleFlowFunction<Double, DoubleFlowFunction> {
        private final LambdaReflection.SerializableDoubleUnaryOperator intUnaryOperator;

        public MapDouble2ToDoubleFlowFunction(DoubleFlowFunction inputEventStream, LambdaReflection.SerializableDoubleUnaryOperator intUnaryOperator) {
            super(inputEventStream, intUnaryOperator);
            this.intUnaryOperator = intUnaryOperator;
        }

        @Override
        protected void mapOperation() {
            this.result = this.intUnaryOperator.applyAsDouble(((DoubleFlowFunction)this.getInputEventStream()).getAsDouble());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapDouble2ToDoubleFlowFunction)) {
                return false;
            }
            MapDouble2ToDoubleFlowFunction other = (MapDouble2ToDoubleFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableDoubleUnaryOperator this$intUnaryOperator = this.intUnaryOperator;
            LambdaReflection.SerializableDoubleUnaryOperator other$intUnaryOperator = other.intUnaryOperator;
            return !(this$intUnaryOperator == null ? other$intUnaryOperator != null : !this$intUnaryOperator.equals(other$intUnaryOperator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapDouble2ToDoubleFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableDoubleUnaryOperator $intUnaryOperator = this.intUnaryOperator;
            result = result * 59 + ($intUnaryOperator == null ? 43 : $intUnaryOperator.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MapFlowFunction.MapDouble2ToDoubleFlowFunction(intUnaryOperator=" + this.intUnaryOperator + ")";
        }
    }

    public static class MapRef2ToDoubleFlowFunction<R, S extends FlowFunction<R>>
    extends AbstractMapToDoubleFlowFunction<R, S> {
        private final LambdaReflection.SerializableToDoubleFunction<R> intUnaryOperator;

        public MapRef2ToDoubleFlowFunction(S inputEventStream, LambdaReflection.SerializableToDoubleFunction<R> intUnaryOperator) {
            super(inputEventStream, intUnaryOperator);
            this.intUnaryOperator = intUnaryOperator;
        }

        @Override
        protected void mapOperation() {
            this.result = this.intUnaryOperator.applyAsDouble(this.getInputEventStream().get());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapRef2ToDoubleFlowFunction)) {
                return false;
            }
            MapRef2ToDoubleFlowFunction other = (MapRef2ToDoubleFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableToDoubleFunction<R> this$intUnaryOperator = this.intUnaryOperator;
            LambdaReflection.SerializableToDoubleFunction<R> other$intUnaryOperator = other.intUnaryOperator;
            return !(this$intUnaryOperator == null ? other$intUnaryOperator != null : !this$intUnaryOperator.equals(other$intUnaryOperator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapRef2ToDoubleFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableToDoubleFunction<R> $intUnaryOperator = this.intUnaryOperator;
            result = result * 59 + ($intUnaryOperator == null ? 43 : $intUnaryOperator.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MapFlowFunction.MapRef2ToDoubleFlowFunction(intUnaryOperator=" + this.intUnaryOperator + ")";
        }
    }

    static abstract class AbstractMapToDoubleFlowFunction<T, S extends FlowFunction<T>>
    extends MapFlowFunction<T, Double, S>
    implements DoubleFlowFunction {
        protected transient double result;

        public AbstractMapToDoubleFlowFunction(S inputEventStream, LambdaReflection.MethodReferenceReflection method) {
            super(inputEventStream, method);
        }

        @Override
        protected void resetOperation() {
            this.result = (Double)this.resetFunction.reset();
        }

        @Override
        public Double get() {
            return this.getAsDouble();
        }

        @Override
        public double getAsDouble() {
            return this.result;
        }
    }

    public static class MapLong2ToIntFlowFunction
    extends AbstractMapToIntFlowFunction<Long, LongFlowFunction> {
        private final LambdaReflection.SerializableLongToIntFunction intUnaryOperator;

        public MapLong2ToIntFlowFunction(LongFlowFunction inputEventStream, LambdaReflection.SerializableLongToIntFunction intUnaryOperator) {
            super(inputEventStream, intUnaryOperator);
            this.intUnaryOperator = intUnaryOperator;
        }

        @Override
        protected void mapOperation() {
            this.result = this.intUnaryOperator.applyAsInt(((LongFlowFunction)this.getInputEventStream()).getAsLong());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapLong2ToIntFlowFunction)) {
                return false;
            }
            MapLong2ToIntFlowFunction other = (MapLong2ToIntFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableLongToIntFunction this$intUnaryOperator = this.intUnaryOperator;
            LambdaReflection.SerializableLongToIntFunction other$intUnaryOperator = other.intUnaryOperator;
            return !(this$intUnaryOperator == null ? other$intUnaryOperator != null : !this$intUnaryOperator.equals(other$intUnaryOperator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapLong2ToIntFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableLongToIntFunction $intUnaryOperator = this.intUnaryOperator;
            result = result * 59 + ($intUnaryOperator == null ? 43 : $intUnaryOperator.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MapFlowFunction.MapLong2ToIntFlowFunction(intUnaryOperator=" + this.intUnaryOperator + ")";
        }
    }

    public static class MapDouble2ToIntFlowFunction
    extends AbstractMapToIntFlowFunction<Double, DoubleFlowFunction> {
        private final LambdaReflection.SerializableDoubleToIntFunction intUnaryOperator;

        public MapDouble2ToIntFlowFunction(DoubleFlowFunction inputEventStream, LambdaReflection.SerializableDoubleToIntFunction intUnaryOperator) {
            super(inputEventStream, intUnaryOperator);
            this.intUnaryOperator = intUnaryOperator;
        }

        @Override
        protected void mapOperation() {
            this.result = this.intUnaryOperator.applyAsInt(((DoubleFlowFunction)this.getInputEventStream()).getAsDouble());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapDouble2ToIntFlowFunction)) {
                return false;
            }
            MapDouble2ToIntFlowFunction other = (MapDouble2ToIntFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableDoubleToIntFunction this$intUnaryOperator = this.intUnaryOperator;
            LambdaReflection.SerializableDoubleToIntFunction other$intUnaryOperator = other.intUnaryOperator;
            return !(this$intUnaryOperator == null ? other$intUnaryOperator != null : !this$intUnaryOperator.equals(other$intUnaryOperator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapDouble2ToIntFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableDoubleToIntFunction $intUnaryOperator = this.intUnaryOperator;
            result = result * 59 + ($intUnaryOperator == null ? 43 : $intUnaryOperator.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MapFlowFunction.MapDouble2ToIntFlowFunction(intUnaryOperator=" + this.intUnaryOperator + ")";
        }
    }

    public static class MapInt2ToIntFlowFunction
    extends AbstractMapToIntFlowFunction<Integer, IntFlowFunction> {
        @NoTriggerReference
        private final LambdaReflection.SerializableIntUnaryOperator intUnaryOperator;

        public MapInt2ToIntFlowFunction(IntFlowFunction inputEventStream, LambdaReflection.SerializableIntUnaryOperator intUnaryOperator) {
            super(inputEventStream, intUnaryOperator);
            this.intUnaryOperator = intUnaryOperator;
        }

        @Override
        protected void mapOperation() {
            this.result = this.intUnaryOperator.applyAsInt(((IntFlowFunction)this.getInputEventStream()).getAsInt());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapInt2ToIntFlowFunction)) {
                return false;
            }
            MapInt2ToIntFlowFunction other = (MapInt2ToIntFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableIntUnaryOperator this$intUnaryOperator = this.intUnaryOperator;
            LambdaReflection.SerializableIntUnaryOperator other$intUnaryOperator = other.intUnaryOperator;
            return !(this$intUnaryOperator == null ? other$intUnaryOperator != null : !this$intUnaryOperator.equals(other$intUnaryOperator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapInt2ToIntFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableIntUnaryOperator $intUnaryOperator = this.intUnaryOperator;
            result = result * 59 + ($intUnaryOperator == null ? 43 : $intUnaryOperator.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MapFlowFunction.MapInt2ToIntFlowFunction(intUnaryOperator=" + this.intUnaryOperator + ")";
        }
    }

    public static class MapRef2ToIntFlowFunction<R, S extends FlowFunction<R>>
    extends AbstractMapToIntFlowFunction<R, S> {
        private final LambdaReflection.SerializableToIntFunction<R> intUnaryOperator;

        public MapRef2ToIntFlowFunction(S inputEventStream, LambdaReflection.SerializableToIntFunction<R> intUnaryOperator) {
            super(inputEventStream, intUnaryOperator);
            this.intUnaryOperator = intUnaryOperator;
        }

        @Override
        protected void mapOperation() {
            this.result = this.intUnaryOperator.applyAsInt(this.getInputEventStream().get());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapRef2ToIntFlowFunction)) {
                return false;
            }
            MapRef2ToIntFlowFunction other = (MapRef2ToIntFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableToIntFunction<R> this$intUnaryOperator = this.intUnaryOperator;
            LambdaReflection.SerializableToIntFunction<R> other$intUnaryOperator = other.intUnaryOperator;
            return !(this$intUnaryOperator == null ? other$intUnaryOperator != null : !this$intUnaryOperator.equals(other$intUnaryOperator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapRef2ToIntFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableToIntFunction<R> $intUnaryOperator = this.intUnaryOperator;
            result = result * 59 + ($intUnaryOperator == null ? 43 : $intUnaryOperator.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MapFlowFunction.MapRef2ToIntFlowFunction(intUnaryOperator=" + this.intUnaryOperator + ")";
        }
    }

    static abstract class AbstractMapToIntFlowFunction<T, S extends FlowFunction<T>>
    extends MapFlowFunction<T, Integer, S>
    implements IntFlowFunction {
        protected transient int result;

        public AbstractMapToIntFlowFunction(S inputEventStream, LambdaReflection.MethodReferenceReflection method) {
            super(inputEventStream, method);
        }

        @Override
        protected void resetOperation() {
            this.result = (Integer)this.resetFunction.reset();
        }

        @Override
        public Integer get() {
            return this.getAsInt();
        }

        @Override
        public int getAsInt() {
            return this.result;
        }
    }

    public static class MapLong2RefFlowFunction<R>
    extends MapFlowFunction<Long, R, LongFlowFunction> {
        private final LambdaReflection.SerializableLongFunction<R> mapFunction;

        public MapLong2RefFlowFunction(LongFlowFunction inputEventStream, LambdaReflection.SerializableLongFunction<R> mapFunction) {
            super(inputEventStream, mapFunction);
            this.mapFunction = mapFunction;
        }

        @Override
        protected void mapOperation() {
            this.result = this.mapFunction.apply(((LongFlowFunction)this.getInputEventStream()).getAsLong());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapLong2RefFlowFunction)) {
                return false;
            }
            MapLong2RefFlowFunction other = (MapLong2RefFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableLongFunction<R> this$mapFunction = this.mapFunction;
            LambdaReflection.SerializableLongFunction<R> other$mapFunction = other.mapFunction;
            return !(this$mapFunction == null ? other$mapFunction != null : !this$mapFunction.equals(other$mapFunction));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapLong2RefFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableLongFunction<R> $mapFunction = this.mapFunction;
            result = result * 59 + ($mapFunction == null ? 43 : $mapFunction.hashCode());
            return result;
        }
    }

    public static class MapDouble2RefFlowFunction<R>
    extends MapFlowFunction<Double, R, DoubleFlowFunction> {
        private final LambdaReflection.SerializableDoubleFunction<R> mapFunction;

        public MapDouble2RefFlowFunction(DoubleFlowFunction inputEventStream, LambdaReflection.SerializableDoubleFunction<R> mapFunction) {
            super(inputEventStream, mapFunction);
            this.mapFunction = mapFunction;
        }

        @Override
        protected void mapOperation() {
            this.result = this.mapFunction.apply(((DoubleFlowFunction)this.getInputEventStream()).getAsDouble());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapDouble2RefFlowFunction)) {
                return false;
            }
            MapDouble2RefFlowFunction other = (MapDouble2RefFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableDoubleFunction<R> this$mapFunction = this.mapFunction;
            LambdaReflection.SerializableDoubleFunction<R> other$mapFunction = other.mapFunction;
            return !(this$mapFunction == null ? other$mapFunction != null : !this$mapFunction.equals(other$mapFunction));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapDouble2RefFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableDoubleFunction<R> $mapFunction = this.mapFunction;
            result = result * 59 + ($mapFunction == null ? 43 : $mapFunction.hashCode());
            return result;
        }
    }

    public static class MapInt2RefFlowFunction<R>
    extends MapFlowFunction<Integer, R, IntFlowFunction> {
        private final LambdaReflection.SerializableIntFunction<R> mapFunction;

        public MapInt2RefFlowFunction(IntFlowFunction inputEventStream, LambdaReflection.SerializableIntFunction<R> mapFunction) {
            super(inputEventStream, mapFunction);
            this.mapFunction = mapFunction;
        }

        @Override
        protected void mapOperation() {
            this.result = this.mapFunction.apply(((IntFlowFunction)this.getInputEventStream()).getAsInt());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapInt2RefFlowFunction)) {
                return false;
            }
            MapInt2RefFlowFunction other = (MapInt2RefFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableIntFunction<R> this$mapFunction = this.mapFunction;
            LambdaReflection.SerializableIntFunction<R> other$mapFunction = other.mapFunction;
            return !(this$mapFunction == null ? other$mapFunction != null : !this$mapFunction.equals(other$mapFunction));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapInt2RefFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableIntFunction<R> $mapFunction = this.mapFunction;
            result = result * 59 + ($mapFunction == null ? 43 : $mapFunction.hashCode());
            return result;
        }
    }

    public static class MapRef2RefFlowFunction<T, R, S extends FlowFunction<T>>
    extends MapFlowFunction<T, R, S> {
        private final LambdaReflection.SerializableFunction<T, R> mapFunction;

        public MapRef2RefFlowFunction(S inputEventStream, LambdaReflection.SerializableFunction<T, R> mapFunction) {
            super(inputEventStream, mapFunction);
            this.mapFunction = mapFunction;
        }

        @Override
        protected void mapOperation() {
            this.result = this.mapFunction.apply(this.getInputEventStream().get());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapRef2RefFlowFunction)) {
                return false;
            }
            MapRef2RefFlowFunction other = (MapRef2RefFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableFunction<T, R> this$mapFunction = this.mapFunction;
            LambdaReflection.SerializableFunction<T, R> other$mapFunction = other.mapFunction;
            return !(this$mapFunction == null ? other$mapFunction != null : !this$mapFunction.equals(other$mapFunction));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapRef2RefFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableFunction<T, R> $mapFunction = this.mapFunction;
            result = result * 59 + ($mapFunction == null ? 43 : $mapFunction.hashCode());
            return result;
        }
    }
}

