/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.function;

import com.fluxtion.runtime.annotations.NoTriggerReference;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.annotations.PushReference;
import com.fluxtion.runtime.annotations.builder.Inject;
import com.fluxtion.runtime.dataflow.DoubleFlowFunction;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.IntFlowFunction;
import com.fluxtion.runtime.dataflow.LongFlowFunction;
import com.fluxtion.runtime.dataflow.function.AbstractFlowFunction;
import com.fluxtion.runtime.node.NodeNameLookup;
import java.util.Objects;

public class NotifyFlowFunction<T, S extends FlowFunction<T>>
extends AbstractFlowFunction<T, T, S> {
    @PushReference
    private final Object target;
    private final transient String auditInfo;
    private String instanceNameToNotify;
    @Inject
    @NoTriggerReference
    public NodeNameLookup nodeNameLookup;

    public NotifyFlowFunction(S inputEventStream, Object target) {
        super(inputEventStream, null);
        this.target = target;
        this.auditInfo = target.getClass().getSimpleName();
    }

    @Override
    protected void initialise() {
        this.instanceNameToNotify = this.nodeNameLookup.lookupInstanceName(this.target);
    }

    @OnTrigger
    public boolean notifyChild() {
        this.auditLog.info("notifyClass", this.auditInfo);
        this.auditLog.info("notifyInstance", this.instanceNameToNotify);
        return this.fireEventUpdateNotification();
    }

    @Override
    public T get() {
        return this.getInputEventStream().get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotifyFlowFunction)) {
            return false;
        }
        NotifyFlowFunction that = (NotifyFlowFunction)o;
        return this.target.equals(that.target);
    }

    public int hashCode() {
        return Objects.hash(this.target);
    }

    @Override
    public String toString() {
        return "NotifyFlowFunction(target=" + this.target + ", auditInfo=" + this.auditInfo + ", instanceNameToNotify=" + this.instanceNameToNotify + ", nodeNameLookup=" + this.nodeNameLookup + ")";
    }

    public static class LongNotifyFlowFunction
    extends NotifyFlowFunction<Long, LongFlowFunction>
    implements LongFlowFunction {
        public LongNotifyFlowFunction(LongFlowFunction inputEventStream, Object target) {
            super(inputEventStream, target);
        }

        @Override
        public long getAsLong() {
            return ((LongFlowFunction)this.getInputEventStream()).getAsLong();
        }

        @Override
        public String toString() {
            return "NotifyFlowFunction.LongNotifyFlowFunction()";
        }
    }

    public static class DoubleNotifyFlowFunction
    extends NotifyFlowFunction<Double, DoubleFlowFunction>
    implements DoubleFlowFunction {
        public DoubleNotifyFlowFunction(DoubleFlowFunction inputEventStream, Object target) {
            super(inputEventStream, target);
        }

        @Override
        public double getAsDouble() {
            return ((DoubleFlowFunction)this.getInputEventStream()).getAsDouble();
        }

        @Override
        public String toString() {
            return "NotifyFlowFunction.DoubleNotifyFlowFunction()";
        }
    }

    public static class IntNotifyFlowFunction
    extends NotifyFlowFunction<Integer, IntFlowFunction>
    implements IntFlowFunction {
        public IntNotifyFlowFunction(IntFlowFunction inputEventStream, Object target) {
            super(inputEventStream, target);
        }

        @Override
        public int getAsInt() {
            return ((IntFlowFunction)this.getInputEventStream()).getAsInt();
        }

        @Override
        public String toString() {
            return "NotifyFlowFunction.IntNotifyFlowFunction()";
        }
    }
}

