/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.function;

import com.fluxtion.runtime.annotations.NoTriggerReference;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.dataflow.DoubleFlowFunction;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.IntFlowFunction;
import com.fluxtion.runtime.dataflow.LongFlowFunction;
import com.fluxtion.runtime.dataflow.function.AbstractFlowFunction;
import com.fluxtion.runtime.partition.LambdaReflection;

public class PeekFlowFunction<T, S extends FlowFunction<T>>
extends AbstractFlowFunction<T, T, S> {
    @NoTriggerReference
    final LambdaReflection.SerializableConsumer<? super T> eventStreamConsumer;
    final transient String auditInfo;

    public PeekFlowFunction(S inputEventStream, LambdaReflection.SerializableConsumer<? super T> eventStreamConsumer) {
        super(inputEventStream, eventStreamConsumer);
        this.eventStreamConsumer = eventStreamConsumer;
        this.auditInfo = eventStreamConsumer.method().getDeclaringClass().getSimpleName() + "->" + eventStreamConsumer.method().getName();
    }

    @OnTrigger
    public void peek() {
        this.auditLog.info("peekConsumer", this.auditInfo);
        this.eventStreamConsumer.accept(this.get());
    }

    @Override
    public T get() {
        return this.getInputEventStream().get();
    }

    public static class LongPeekFlowFunction
    extends PeekFlowFunction<Long, LongFlowFunction>
    implements LongFlowFunction {
        public LongPeekFlowFunction(LongFlowFunction inputEventStream, LambdaReflection.SerializableConsumer<? super Long> eventStreamConsumer) {
            super(inputEventStream, eventStreamConsumer);
        }

        @Override
        public long getAsLong() {
            return ((LongFlowFunction)this.getInputEventStream()).getAsLong();
        }

        @Override
        public String toString() {
            return "PeekFlowFunction.LongPeekFlowFunction()";
        }
    }

    public static class DoublePeekFlowFunction
    extends PeekFlowFunction<Double, DoubleFlowFunction>
    implements DoubleFlowFunction {
        public DoublePeekFlowFunction(DoubleFlowFunction inputEventStream, LambdaReflection.SerializableConsumer<? super Double> eventStreamConsumer) {
            super(inputEventStream, eventStreamConsumer);
        }

        @Override
        public double getAsDouble() {
            return ((DoubleFlowFunction)this.getInputEventStream()).getAsDouble();
        }

        @Override
        public String toString() {
            return "PeekFlowFunction.DoublePeekFlowFunction()";
        }
    }

    public static class IntPeekFlowFunction
    extends PeekFlowFunction<Integer, IntFlowFunction>
    implements IntFlowFunction {
        public IntPeekFlowFunction(IntFlowFunction inputEventStream, LambdaReflection.SerializableConsumer<? super Integer> eventStreamConsumer) {
            super(inputEventStream, eventStreamConsumer);
        }

        @Override
        public int getAsInt() {
            return ((IntFlowFunction)this.getInputEventStream()).getAsInt();
        }

        @Override
        public String toString() {
            return "PeekFlowFunction.IntPeekFlowFunction()";
        }
    }
}

