/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.groupby;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public interface GroupBy<K, V> {
    public static final KeyValue<?, ?> KV_KEY_VALUE = new KeyValue<Object, Object>(null, null);

    public Map<K, V> toMap();

    public Collection<V> values();

    default public V lastValue() {
        return null;
    }

    default public KeyValue<K, V> lastKeyValue() {
        return GroupBy.emptyKey();
    }

    public static <K, V> KeyValue<K, V> emptyKey() {
        return KV_KEY_VALUE;
    }

    public static <K, V> GroupBy<K, V> emptyCollection() {
        return new EmptyGroupBy();
    }

    public static class EmptyGroupBy<K, V>
    implements GroupBy<K, V> {
        @Override
        public V lastValue() {
            return null;
        }

        @Override
        public KeyValue<K, V> lastKeyValue() {
            return null;
        }

        @Override
        public Map<K, V> toMap() {
            return Collections.emptyMap();
        }

        @Override
        public Collection<V> values() {
            return Collections.emptyList();
        }
    }

    public static final class KeyValue<K, V> {
        private final K key;
        private final V value;

        public Double getValueAsDouble() {
            return (Double)this.value;
        }

        public Long getValueAsLong() {
            return (Long)this.value;
        }

        public Integer getValueAsInt() {
            return (Integer)this.value;
        }

        public KeyValue(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyValue)) {
                return false;
            }
            KeyValue other = (KeyValue)o;
            K this$key = this.getKey();
            K other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            V this$value = this.getValue();
            V other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            K $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            V $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "GroupBy.KeyValue(key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }
    }
}

