/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.groupby;

import com.fluxtion.runtime.partition.LambdaReflection;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class GroupByKey<T> {
    public final List<LambdaReflection.SerializableFunction<T, ?>> accessors;
    public final transient List<Method> accessorsMethods;
    private final transient StringBuilder keyHolder = new StringBuilder();
    private final transient Class<T> valueClass;
    private transient String key;
    private transient T keyInstance;
    private final transient String name;

    public GroupByKey(List<LambdaReflection.SerializableFunction<T, ?>> accessorsToAdd) {
        this.accessors = new ArrayList();
        this.accessorsMethods = new ArrayList<Method>();
        String tmpName = "";
        for (LambdaReflection.SerializableFunction<T, ?> element : accessorsToAdd) {
            if (this.accessors.contains(element)) continue;
            this.accessors.add(element);
            tmpName = tmpName + "_" + element.method().getName();
            this.accessorsMethods.add(element.method());
        }
        this.valueClass = this.accessors.get(0).method().getDeclaringClass();
        this.name = this.valueClass.getName() + tmpName;
    }

    public GroupByKey(LambdaReflection.SerializableFunction<T, ?> accessor) {
        this(Arrays.asList(accessor));
    }

    @SafeVarargs
    public GroupByKey(LambdaReflection.SerializableFunction<T, ?> ... accessorList) {
        this(Arrays.asList(accessorList));
    }

    private GroupByKey(GroupByKey<T> toClone) {
        this.accessors = toClone.accessors;
        this.accessorsMethods = toClone.accessorsMethods;
        this.valueClass = toClone.getValueClass();
        this.name = toClone.name;
    }

    public static <T> LambdaReflection.SerializableFunction<T, GroupByKey<T>> build(LambdaReflection.SerializableFunction<T, ?> accessor) {
        return new GroupByKey<T>(accessor)::toKey;
    }

    @SafeVarargs
    public static <T> LambdaReflection.SerializableFunction<T, GroupByKey<T>> build(LambdaReflection.SerializableFunction<T, ?> ... accessorList) {
        ArrayList accessors = new ArrayList();
        accessors.addAll(Arrays.asList(accessorList));
        GroupByKey<T> accessorKey = new GroupByKey<T>(accessors);
        return accessorKey::toKey;
    }

    public boolean keyPresent(LambdaReflection.SerializableFunction<T, ?> keyToCheck) {
        return this.accessorsMethods.contains(keyToCheck.method());
    }

    public GroupByKey<T> toKey(T input) {
        GroupByKey<T> cloned = new GroupByKey<T>(this);
        cloned.keyHolder.setLength(0);
        cloned.keyInstance = input;
        int accessorsSize = this.accessors.size();
        for (int i = 0; i < accessorsSize; ++i) {
            LambdaReflection.SerializableFunction<T, ?> accessor = this.accessors.get(i);
            cloned.keyHolder.append(accessor.apply(input).toString());
            cloned.keyHolder.append("_");
        }
        cloned.key = cloned.keyHolder.toString();
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupByKey that = (GroupByKey)o;
        if (!this.valueClass.equals(that.valueClass)) {
            return false;
        }
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.valueClass.hashCode();
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return "GroupByKey(key=" + this.getKey() + ", name=" + this.name + ")";
    }

    public Class<T> getValueClass() {
        return this.valueClass;
    }

    public String getKey() {
        return this.key;
    }

    public T getKeyInstance() {
        return this.keyInstance;
    }
}

