/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.groupby;

import com.fluxtion.runtime.annotations.builder.SepNode;
import com.fluxtion.runtime.dataflow.groupby.GroupBy;
import com.fluxtion.runtime.dataflow.groupby.GroupByHashMap;
import com.fluxtion.runtime.dataflow.groupby.GroupByView;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.util.Collections;
import java.util.Map;

public class GroupByMapFlowFunction {
    private final LambdaReflection.SerializableFunction mapFunction;
    private final LambdaReflection.SerializableBiFunction mapFrom2MapsBiFunction;
    private final transient GroupByHashMap outputCollection = new GroupByHashMap();
    private final transient GroupByView wrappedCollection = new GroupByView();
    @SepNode
    public Object defaultValue;

    public <T, R> GroupByMapFlowFunction(LambdaReflection.SerializableFunction<T, R> mapFunction) {
        this(mapFunction, null);
    }

    public <A, B, R> GroupByMapFlowFunction(LambdaReflection.SerializableBiFunction<A, B, R> mapFrom2MapsBiFunction) {
        this(null, mapFrom2MapsBiFunction);
    }

    public <K, V, A, O> GroupByMapFlowFunction(LambdaReflection.SerializableFunction<A, K> mapFunction, LambdaReflection.SerializableBiFunction<V, A, O> mapFrom2MapsBiFunction) {
        this.mapFunction = mapFunction;
        this.mapFrom2MapsBiFunction = mapFrom2MapsBiFunction;
    }

    public <K, V, A, O> GroupByMapFlowFunction(LambdaReflection.SerializableFunction<A, K> mapFunction, LambdaReflection.SerializableBiFunction<V, A, O> mapFrom2MapsBiFunction, Object defaultValue) {
        this.mapFunction = mapFunction;
        this.mapFrom2MapsBiFunction = mapFrom2MapsBiFunction;
        this.defaultValue = defaultValue;
    }

    public <K, V> GroupBy<K, V> mapValues(Object inputMap) {
        return this.mapValues((GroupBy)inputMap);
    }

    public <K, V> GroupBy<K, V> mapForEachValues(Object inputMap) {
        return this.mapForEachValues((GroupBy)inputMap);
    }

    public <K, V> GroupBy<K, V> mapKeyedValue(Object inputMap, Object secondArgument) {
        return this.mapKeyedValue((GroupBy)inputMap, secondArgument);
    }

    public <K, R> GroupBy<K, R> mapValueWithKeyValue(Object inputMap, GroupBy.KeyValue secondArgument) {
        return this.mapValueWithKeyValue((GroupBy)inputMap, secondArgument);
    }

    public <K, V> GroupBy<K, V> biMapValuesWithParamMap(Object firstArgGroupBy, Object secondArgGroupBY) {
        return this.biMapValuesWithParamMap((GroupBy)firstArgGroupBy, (GroupBy)secondArgGroupBY);
    }

    public <K, V> GroupBy<K, V> mapKeys(Object inputMap) {
        return this.mapKeys((GroupBy)inputMap);
    }

    public <K, V> GroupBy<K, V> mapEntry(Object inputMap) {
        return this.mapEntry((GroupBy)inputMap);
    }

    public <K, V> GroupBy<K, V> mapForEachValues(GroupBy inputMap) {
        throw new UnsupportedOperationException("not implemented");
    }

    public <K, V> GroupBy<K, V> mapValues(GroupBy inputMap) {
        this.outputCollection.reset();
        inputMap.toMap().entrySet().forEach(e -> {
            Map.Entry entry = (Map.Entry)e;
            this.outputCollection.toMap().put(entry.getKey(), this.mapFunction.apply(entry.getValue()));
        });
        return this.outputCollection;
    }

    public <K, V> GroupBy<K, V> mapKeys(GroupBy inputMap) {
        this.outputCollection.reset();
        inputMap.toMap().entrySet().forEach(e -> {
            Map.Entry entry = (Map.Entry)e;
            this.outputCollection.toMap().put(this.mapFunction.apply(entry.getKey()), entry.getValue());
        });
        return this.outputCollection;
    }

    public <K, V> GroupBy<K, V> mapEntry(GroupBy inputMap) {
        this.outputCollection.reset();
        inputMap.toMap().entrySet().forEach(e -> {
            Map.Entry entry = (Map.Entry)this.mapFunction.apply(e);
            this.outputCollection.toMap().put(entry.getKey(), entry.getValue());
        });
        return this.outputCollection;
    }

    public <K, G extends GroupBy, R> GroupBy<K, R> mapKeyedValue(G inputMap, Object argumentProvider) {
        this.wrappedCollection.reset();
        Object key = this.mapFunction.apply(argumentProvider);
        Object item = inputMap.toMap().get(key);
        if (item != null) {
            GroupBy.KeyValue kv = new GroupBy.KeyValue(key, this.mapFrom2MapsBiFunction.apply(item, argumentProvider));
            this.outputCollection.fromMap(inputMap.toMap());
            this.outputCollection.add(kv);
            this.wrappedCollection.setGroupBy(this.outputCollection);
            this.wrappedCollection.setKeyValue(kv);
        }
        return this.wrappedCollection;
    }

    public <K, G extends GroupBy, R> GroupBy<K, R> mapValueWithKeyValue(G inputMap, GroupBy.KeyValue argumentProvider) {
        this.wrappedCollection.reset();
        Object key = argumentProvider.getKey();
        Object item = inputMap.toMap().get(key);
        if (item != null) {
            GroupBy.KeyValue kv = new GroupBy.KeyValue(key, this.mapFrom2MapsBiFunction.apply(item, argumentProvider.getValue()));
            this.outputCollection.fromMap(inputMap.toMap());
            this.outputCollection.add(kv);
            this.wrappedCollection.setGroupBy(this.outputCollection);
            this.wrappedCollection.setKeyValue(kv);
        }
        return this.wrappedCollection;
    }

    public <K, G extends GroupBy, H extends GroupBy, R> GroupBy<K, R> biMapValuesWithParamMap(G firstArgGroupBy, H secondArgGroupBY) {
        this.outputCollection.reset();
        Map arg2Map = secondArgGroupBY == null && this.defaultValue != null ? Collections.emptyMap() : secondArgGroupBY.toMap();
        firstArgGroupBy.toMap().forEach((key, arg1) -> {
            Object arg2 = arg2Map.getOrDefault(key, this.defaultValue);
            if (arg2 != null) {
                this.outputCollection.toMap().put(key, this.mapFrom2MapsBiFunction.apply(arg1, arg2));
            }
        });
        return this.outputCollection;
    }
}

