/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.helpers;

import com.fluxtion.runtime.annotations.builder.SepNode;
import com.fluxtion.runtime.dataflow.DefaultValueSupplier;
import com.fluxtion.runtime.dataflow.Stateful;
import com.fluxtion.runtime.partition.LambdaReflection;

public class DefaultValue<T>
implements DefaultValueSupplier,
Stateful<T> {
    @SepNode
    private final T defaultValue;

    public DefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public T getOrDefault(T input) {
        return input == null ? this.defaultValue : input;
    }

    @Override
    public T reset() {
        return this.defaultValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultValue)) {
            return false;
        }
        DefaultValue other = (DefaultValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$defaultValue = this.defaultValue;
        T other$defaultValue = other.defaultValue;
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $defaultValue = this.defaultValue;
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }

    public static class DefaultLong
    implements DefaultValueSupplier,
    Stateful<Long> {
        private final long defaultValue;
        private boolean inputUpdatedAtLeastOnce;

        public DefaultLong(long defaultValue) {
            this.defaultValue = defaultValue;
        }

        public long getOrDefault(long input) {
            this.inputUpdatedAtLeastOnce |= input != 0L;
            if (this.inputUpdatedAtLeastOnce) {
                return input;
            }
            return this.defaultValue;
        }

        @Override
        public Long reset() {
            this.inputUpdatedAtLeastOnce = false;
            return this.defaultValue;
        }
    }

    public static class DefaultDouble
    implements DefaultValueSupplier,
    Stateful<Double> {
        private final double defaultValue;
        private boolean inputUpdatedAtLeastOnce;

        public DefaultDouble(double defaultValue) {
            this.defaultValue = defaultValue;
        }

        public double getOrDefault(double input) {
            this.inputUpdatedAtLeastOnce |= input != 0.0;
            if (this.inputUpdatedAtLeastOnce) {
                return input;
            }
            return this.defaultValue;
        }

        @Override
        public Double reset() {
            this.inputUpdatedAtLeastOnce = false;
            return this.defaultValue;
        }
    }

    public static class DefaultInt
    implements DefaultValueSupplier,
    Stateful<Integer> {
        private final int defaultValue;
        private boolean inputUpdatedAtLeastOnce;

        public DefaultInt(int defaultValue) {
            this.defaultValue = defaultValue;
        }

        public int getOrDefault(int input) {
            this.inputUpdatedAtLeastOnce |= input != 0;
            if (this.inputUpdatedAtLeastOnce) {
                return input;
            }
            return this.defaultValue;
        }

        @Override
        public Integer reset() {
            this.inputUpdatedAtLeastOnce = false;
            return this.defaultValue;
        }
    }

    public static class DefaultValueFromSupplier<T>
    implements DefaultValueSupplier,
    Stateful<T> {
        private final LambdaReflection.SerializableSupplier<T> defaultSupplier;
        private final transient T defaultValue;

        public DefaultValueFromSupplier(LambdaReflection.SerializableSupplier<T> defaultSupplier) {
            this.defaultSupplier = defaultSupplier;
            this.defaultValue = defaultSupplier.get();
        }

        public T getOrDefault(T input) {
            return input == null ? this.defaultValue : input;
        }

        @Override
        public T reset() {
            return this.defaultValue;
        }
    }
}

