/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.helpers;

import com.fluxtion.runtime.annotations.NoTriggerReference;
import com.fluxtion.runtime.annotations.builder.Inject;
import com.fluxtion.runtime.partition.LambdaReflection;
import com.fluxtion.runtime.time.Clock;

public interface Peekers {
    public static <T> LambdaReflection.SerializableConsumer<T> console(String message) {
        return new TemplateMessage(message, null)::templateAndLogToConsole;
    }

    public static <T, R> LambdaReflection.SerializableConsumer<T> console(String message, LambdaReflection.SerializableFunction<T, R> transform) {
        return new TemplateMessage<T>(message, transform)::templateAndLogToConsole;
    }

    public static void println(Object message) {
        System.out.println(message);
    }

    public static class TemplateMessage<T> {
        @Inject
        @NoTriggerReference
        public Clock clock;
        private final String message;
        private final LambdaReflection.SerializableFunction<T, ?> transformFunction;

        public TemplateMessage(String message, LambdaReflection.SerializableFunction<T, ?> transformFunction) {
            this.message = message;
            this.transformFunction = transformFunction;
        }

        public TemplateMessage(String message) {
            this.message = message;
            this.transformFunction = null;
        }

        public void templateAndLogToConsole(T input) {
            String output = this.transformFunction == null ? input.toString() : this.transformFunction.apply(input).toString();
            System.out.println(this.message.replace("{}", output).replace("%e", "" + this.clock.getEventTime()).replace("{}", output).replace("%t", "" + this.clock.getWallClockTime()).replace("{}", output).replace("%p", "" + this.clock.getProcessTime()));
        }
    }
}

