/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.helpers;

import com.fluxtion.runtime.annotations.Initialise;
import com.fluxtion.runtime.annotations.OnParentUpdate;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.annotations.builder.AssignToField;
import com.fluxtion.runtime.dataflow.Stateful;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface Predicates {
    public static boolean greaterThanInt(int a, int b) {
        return a > b;
    }

    public static boolean greaterThanDouble(double a, double b) {
        return a > b;
    }

    public static boolean greaterThanLong(long a, long b) {
        return a > b;
    }

    public static boolean isInteger(String in) {
        try {
            Integer.parseInt(in);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isDouble(String in) {
        try {
            Double.parseDouble(in);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isLong(String in) {
        try {
            Long.parseLong(in);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static <T> LambdaReflection.SerializableFunction<T, Boolean> hasChangedFilter() {
        return new HasChanged()::objChanged;
    }

    public static <K, V> LambdaReflection.SerializableFunction<Map<K, V>, Boolean> hasMapChanged() {
        return new MapHasChanged()::checkMapChanged;
    }

    public static LambdaReflection.SerializableIntFunction<Boolean> hasIntChanged() {
        return new HasChanged()::intChanged;
    }

    public static LambdaReflection.SerializableDoubleFunction<Boolean> hasDoubleChanged() {
        return new HasChanged()::doubleChanged;
    }

    public static LambdaReflection.SerializableLongFunction<Boolean> hasLongChanged() {
        return new HasChanged()::longChanged;
    }

    public static LambdaReflection.SerializableIntFunction<Boolean> gt(int limit) {
        return new GreaterThan(limit, Double.NaN)::check;
    }

    public static LambdaReflection.SerializableFunction<Integer, Boolean> greaterThanBoxed(Integer limit) {
        return new GreaterThan(limit.intValue(), Double.NaN)::checkBoxedInteger;
    }

    public static LambdaReflection.SerializableFunction<Long, Boolean> greaterThanBoxed(Long limit) {
        return new GreaterThan(limit, Double.NaN)::checkBoxedLong;
    }

    public static LambdaReflection.SerializableLongFunction<Boolean> gt(long limit) {
        return new GreaterThan(limit, Double.NaN)::check;
    }

    public static LambdaReflection.SerializableDoubleFunction<Boolean> gt(double limit) {
        return new GreaterThan(Long.MAX_VALUE, limit)::check;
    }

    public static LambdaReflection.SerializableIntFunction<Boolean> lt(int limit) {
        return new LessThan(limit, Double.NaN)::check;
    }

    public static LambdaReflection.SerializableLongFunction<Boolean> lt(long limit) {
        return new LessThan(limit, Double.NaN)::check;
    }

    public static LambdaReflection.SerializableDoubleFunction<Boolean> lt(double limit) {
        return new LessThan(Long.MAX_VALUE, limit)::check;
    }

    public static final class PredicateWrapper {
        private final LambdaReflection.SerializableSupplier<Boolean> predicate;

        public boolean test(Object o) {
            return (Boolean)this.predicate.get();
        }

        public PredicateWrapper(LambdaReflection.SerializableSupplier<Boolean> predicate) {
            this.predicate = predicate;
        }

        public LambdaReflection.SerializableSupplier<Boolean> getPredicate() {
            return this.predicate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PredicateWrapper)) {
                return false;
            }
            PredicateWrapper other = (PredicateWrapper)o;
            LambdaReflection.SerializableSupplier<Boolean> this$predicate = this.getPredicate();
            LambdaReflection.SerializableSupplier<Boolean> other$predicate = other.getPredicate();
            return !(this$predicate == null ? other$predicate != null : !this$predicate.equals(other$predicate));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LambdaReflection.SerializableSupplier<Boolean> $predicate = this.getPredicate();
            result = result * 59 + ($predicate == null ? 43 : $predicate.hashCode());
            return result;
        }

        public String toString() {
            return "Predicates.PredicateWrapper(predicate=" + this.getPredicate() + ")";
        }
    }

    public static class AllUpdatedPredicate
    extends Stateful.StatefulWrapper {
        private final List<Object> monitored = new ArrayList<Object>();
        private final transient Map<Object, Boolean> updateMap = new HashMap<Object, Boolean>();
        private boolean allUpdated;

        public AllUpdatedPredicate(@AssignToField(value="monitored") List<?> monitored, @AssignToField(value="resetTrigger") Object resetKey) {
            super(resetKey);
            this.monitored.addAll(monitored);
        }

        public AllUpdatedPredicate(List<?> monitored) {
            this(monitored, null);
        }

        @OnParentUpdate(value="monitored")
        public void parentUpdated(Object parent) {
            if (!this.allUpdated) {
                this.updateMap.put(parent, true);
                this.allUpdated = this.updateMap.values().stream().allMatch(v -> v);
            }
        }

        @OnTrigger
        public boolean propagateEvent() {
            return this.allUpdated;
        }

        @Initialise
        public void init() {
            this.allUpdated = false;
            this.updateMap.clear();
            this.monitored.forEach(p -> this.updateMap.put(p, false));
        }

        @Override
        public void reset() {
            this.init();
        }
    }

    public static final class LessThan {
        private final long limit;
        private final double doubleLimit;

        public boolean check(int input) {
            return (long)input < this.limit;
        }

        public boolean check(double input) {
            return input < this.doubleLimit;
        }

        public boolean check(long input) {
            return input < this.limit;
        }

        public LessThan(long limit, double doubleLimit) {
            this.limit = limit;
            this.doubleLimit = doubleLimit;
        }

        public long getLimit() {
            return this.limit;
        }

        public double getDoubleLimit() {
            return this.doubleLimit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LessThan)) {
                return false;
            }
            LessThan other = (LessThan)o;
            if (this.getLimit() != other.getLimit()) {
                return false;
            }
            return Double.compare(this.getDoubleLimit(), other.getDoubleLimit()) == 0;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $limit = this.getLimit();
            result = result * 59 + (int)($limit >>> 32 ^ $limit);
            long $doubleLimit = Double.doubleToLongBits(this.getDoubleLimit());
            result = result * 59 + (int)($doubleLimit >>> 32 ^ $doubleLimit);
            return result;
        }

        public String toString() {
            return "Predicates.LessThan(limit=" + this.getLimit() + ", doubleLimit=" + this.getDoubleLimit() + ")";
        }
    }

    public static final class GreaterThan {
        private final long limit;
        private final double doubleLimit;

        public boolean check(int input) {
            return (long)input > this.limit;
        }

        public boolean check(double input) {
            return input > this.doubleLimit;
        }

        public boolean check(long input) {
            return input > this.limit;
        }

        public boolean checkBoxedInteger(Integer input) {
            return this.check(input);
        }

        public boolean checkBoxedLong(Long input) {
            return this.check(input);
        }

        public GreaterThan(long limit, double doubleLimit) {
            this.limit = limit;
            this.doubleLimit = doubleLimit;
        }

        public long getLimit() {
            return this.limit;
        }

        public double getDoubleLimit() {
            return this.doubleLimit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GreaterThan)) {
                return false;
            }
            GreaterThan other = (GreaterThan)o;
            if (this.getLimit() != other.getLimit()) {
                return false;
            }
            return Double.compare(this.getDoubleLimit(), other.getDoubleLimit()) == 0;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $limit = this.getLimit();
            result = result * 59 + (int)($limit >>> 32 ^ $limit);
            long $doubleLimit = Double.doubleToLongBits(this.getDoubleLimit());
            result = result * 59 + (int)($doubleLimit >>> 32 ^ $doubleLimit);
            return result;
        }

        public String toString() {
            return "Predicates.GreaterThan(limit=" + this.getLimit() + ", doubleLimit=" + this.getDoubleLimit() + ")";
        }
    }

    public static class MapHasChanged {
        private final Map<Object, Object> oldMap = new HashMap<Object, Object>();

        public <K, V> Boolean checkMapChanged(Map<K, V> map) {
            boolean changed = !map.equals(this.oldMap);
            this.oldMap.clear();
            this.oldMap.putAll(map);
            return changed;
        }
    }

    public static class HasChanged {
        long longPrevious;
        double doublePrevious;
        int previousInt;
        Object previousObject;

        public boolean intChanged(int newValue) {
            boolean changed = newValue != this.previousInt;
            this.previousInt = newValue;
            return changed;
        }

        public boolean longChanged(long newValue) {
            boolean changed = newValue != this.longPrevious;
            this.longPrevious = newValue;
            return changed;
        }

        public boolean doubleChanged(double newValue) {
            if (Double.isNaN(newValue) && Double.isNaN(this.doublePrevious)) {
                return false;
            }
            boolean changed = newValue != this.doublePrevious;
            this.doublePrevious = newValue;
            return changed;
        }

        public <T> boolean objChanged(T newValue) {
            boolean changed = !newValue.equals(this.previousObject);
            this.previousObject = newValue;
            return changed;
        }
    }
}

