/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.event;

import com.fluxtion.runtime.event.Event;

public abstract class DefaultEvent
implements Event {
    public static final int NO_INT_FILTER = Integer.MAX_VALUE;
    public static final String NO_STRING_FILTER = "";
    protected int filterId;
    protected String filterString;
    protected long eventTime;

    public DefaultEvent() {
        this(NO_STRING_FILTER);
    }

    public DefaultEvent(String filterId) {
        this(Integer.MAX_VALUE, filterId);
    }

    public DefaultEvent(int filterId) {
        this(filterId, NO_STRING_FILTER);
    }

    public DefaultEvent(int filterId, String filterString) {
        this.filterId = filterId;
        this.filterString = filterString;
        this.eventTime = System.currentTimeMillis();
    }

    @Override
    public final int filterId() {
        return this.filterId;
    }

    @Override
    public final String filterString() {
        return this.filterString;
    }

    public final CharSequence filterCharSequence() {
        return this.filterString;
    }

    @Override
    public long getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(long eventTime) {
        if (eventTime > 0L) {
            this.eventTime = eventTime;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultEvent)) {
            return false;
        }
        DefaultEvent other = (DefaultEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.filterId != other.filterId) {
            return false;
        }
        if (this.getEventTime() != other.getEventTime()) {
            return false;
        }
        String this$filterString = this.filterString;
        String other$filterString = other.filterString;
        return !(this$filterString == null ? other$filterString != null : !this$filterString.equals(other$filterString));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.filterId;
        long $eventTime = this.getEventTime();
        result = result * 59 + (int)($eventTime >>> 32 ^ $eventTime);
        String $filterString = this.filterString;
        result = result * 59 + ($filterString == null ? 43 : $filterString.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultEvent(filterId=" + this.filterId + ", filterString=" + this.filterString + ", eventTime=" + this.getEventTime() + ")";
    }
}

