/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.input;

import com.fluxtion.runtime.StaticEventProcessor;
import com.fluxtion.runtime.annotations.TearDown;
import com.fluxtion.runtime.input.EventFeed;
import com.fluxtion.runtime.input.SubscriptionManager;
import com.fluxtion.runtime.node.NamedNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SubscriptionManagerNode
implements SubscriptionManager,
NamedNode {
    private final transient List<EventFeed> registeredFeeds = new ArrayList<EventFeed>();
    private final transient Map<Object, Integer> subscriptionMap = new HashMap<Object, Integer>();
    private StaticEventProcessor eventProcessor = StaticEventProcessor.NULL_EVENTHANDLER;

    public void setSubscribingEventProcessor(StaticEventProcessor eventProcessor) {
        this.eventProcessor = eventProcessor;
    }

    public void addEventProcessorFeed(EventFeed eventFeed) {
        if (!this.registeredFeeds.contains(eventFeed)) {
            eventFeed.registerSubscriber(this.eventProcessor);
            this.registeredFeeds.add(eventFeed);
            this.subscriptionMap.keySet().forEach(e -> eventFeed.subscribe(this.eventProcessor, e));
        }
    }

    public void removeEventProcessorFeed(EventFeed eventProcessorFeed) {
        this.registeredFeeds.remove(eventProcessorFeed);
    }

    @Override
    public void subscribe(Object subscriptionId) {
        this.subscriptionMap.compute(subscriptionId, (k, v) -> {
            if (v == null) {
                this.registeredFeeds.forEach(e -> e.subscribe(this.eventProcessor, subscriptionId));
                return 1;
            }
            v = v + 1;
            return v;
        });
    }

    @Override
    public void unSubscribe(Object subscriptionId) {
        this.subscriptionMap.computeIfPresent(subscriptionId, (o, i) -> {
            if ((i = Integer.valueOf(i - 1)) < 1) {
                this.registeredFeeds.forEach(e -> e.unSubscribe(this.eventProcessor, subscriptionId));
                return null;
            }
            return i;
        });
    }

    @TearDown
    public void tearDown() {
        this.registeredFeeds.forEach(e -> e.removeAllSubscriptions(this.eventProcessor));
        this.subscriptionMap.clear();
    }

    @Override
    public String getName() {
        return "subscriptionManager";
    }
}

