/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.ml;

import com.fluxtion.runtime.annotations.Initialise;
import com.fluxtion.runtime.annotations.NoPropagateFunction;
import com.fluxtion.runtime.annotations.builder.AssignToField;
import com.fluxtion.runtime.annotations.feature.Experimental;
import com.fluxtion.runtime.ml.Calibration;
import com.fluxtion.runtime.ml.CalibrationProcessor;
import com.fluxtion.runtime.ml.Feature;
import java.beans.Introspector;
import java.util.List;

@Experimental
public abstract class AbstractFeature
implements Feature,
CalibrationProcessor {
    private final transient String name;
    private final transient String identifier;
    protected double co_efficient;
    protected double weight;
    protected double value;

    public AbstractFeature() {
        this.identifier = this.getClass().getSimpleName();
        this.name = Introspector.decapitalize(this.identifier);
    }

    public AbstractFeature(@AssignToField(value="name") String name, @AssignToField(value="identifier") String identifier) {
        this.name = name;
        this.identifier = identifier;
    }

    @Initialise
    public void init() {
        this.co_efficient = 0.0;
        this.weight = 0.0;
        this.value = 0.0;
    }

    @Override
    @NoPropagateFunction
    public boolean setCalibration(List<Calibration> calibrations) {
        int calibrationsSize = calibrations.size();
        for (int i = 0; i < calibrationsSize; ++i) {
            Calibration calibration = calibrations.get(i);
            if (!calibration.getFeatureIdentifier().equals(this.identifier())) continue;
            this.co_efficient = calibration.getCo_efficient();
            this.weight = calibration.getWeight();
            return true;
        }
        return false;
    }

    @Override
    @NoPropagateFunction
    public boolean resetToOne() {
        this.co_efficient = 1.0;
        this.weight = 1.0;
        return false;
    }

    @Override
    @NoPropagateFunction
    public boolean resetToZero() {
        this.co_efficient = 0.0;
        this.weight = 0.0;
        return false;
    }

    @Override
    public double value() {
        return this.value;
    }

    public double co_efficient() {
        return this.co_efficient;
    }

    public double weight() {
        return this.weight;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

