/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.ml;

import com.fluxtion.runtime.annotations.feature.Experimental;
import com.fluxtion.runtime.dataflow.FlowSupplier;
import com.fluxtion.runtime.ml.CalibrationProcessor;
import com.fluxtion.runtime.ml.PropertyToFeature;
import com.fluxtion.runtime.node.NamedNode;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.List;

@Experimental
public interface Feature
extends NamedNode,
CalibrationProcessor {
    default public String identifier() {
        return this.getClass().getSimpleName();
    }

    @Override
    default public String getName() {
        return Introspector.decapitalize(this.identifier());
    }

    public double value();

    @SafeVarargs
    public static <T> List<Feature> include(FlowSupplier<T> inputDataFlow, LambdaReflection.SerializableToDoubleFunction<T> ... featureExtractors) {
        ArrayList<Feature> featureList = new ArrayList<Feature>(featureExtractors.length);
        for (LambdaReflection.SerializableToDoubleFunction<T> featureExtractor : featureExtractors) {
            featureList.add(PropertyToFeature.build(featureExtractor.method().getName(), inputDataFlow, featureExtractor));
        }
        return featureList;
    }
}

