/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.ml;

import com.fluxtion.runtime.annotations.Initialise;
import com.fluxtion.runtime.annotations.NoPropagateFunction;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.annotations.feature.Experimental;
import com.fluxtion.runtime.ml.Calibration;
import com.fluxtion.runtime.ml.CalibrationProcessor;
import com.fluxtion.runtime.ml.Feature;
import com.fluxtion.runtime.ml.PredictiveModel;
import com.fluxtion.runtime.util.CollectionHelper;
import java.util.Arrays;
import java.util.List;

@Experimental
public class PredictiveLinearRegressionModel
implements PredictiveModel,
CalibrationProcessor {
    private final Feature[] features;
    private final transient List<Feature> immutableFeatures;
    private double prediction = Double.NaN;

    public PredictiveLinearRegressionModel(Feature ... features) {
        this.features = Arrays.copyOf(features, features.length);
        this.immutableFeatures = CollectionHelper.listOf(features);
    }

    public PredictiveLinearRegressionModel(List<Feature> featureList) {
        this(featureList.toArray(new Feature[0]));
    }

    @Initialise
    public void init() {
        this.prediction = Double.NaN;
    }

    @Override
    @NoPropagateFunction
    public boolean setCalibration(List<Calibration> calibrations) {
        return this.calculateInference();
    }

    @OnTrigger
    public boolean calculateInference() {
        this.prediction = 0.0;
        for (Feature feature : this.features) {
            this.prediction += feature.value();
        }
        return true;
    }

    @Override
    public double predictedValue() {
        return this.prediction;
    }

    @Override
    public List<Feature> features() {
        return this.immutableFeatures;
    }
}

