/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.node;

import com.fluxtion.runtime.event.Event;
import java.util.Objects;

public class EventSubscription<T>
implements Event {
    private final int filterId;
    private final String filterString;
    private final Class<T> eventClass;
    private String toString;
    protected long eventTime;

    public EventSubscription(int filterId, String filterString, Class<T> eventClass) {
        this.filterId = filterId;
        this.filterString = filterString;
        this.eventClass = eventClass;
        this.eventTime = System.currentTimeMillis();
        this.toString = "EventSubscription{eventClass=" + eventClass + (filterId == Integer.MAX_VALUE ? "" : ", filterId=" + filterId) + (filterString.isEmpty() ? "" : ", filterString=" + filterString) + '}';
    }

    @Override
    public int filterId() {
        return this.filterId;
    }

    @Override
    public String filterString() {
        return this.filterString;
    }

    public Class<T> eventClass() {
        return this.eventClass;
    }

    public void setEventTime(long eventTime) {
        if (eventTime > 0L) {
            this.eventTime = eventTime;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventSubscription that = (EventSubscription)o;
        return this.filterId == that.filterId && this.filterString.equals(that.filterString) && this.eventClass.equals(that.eventClass);
    }

    public int hashCode() {
        return Objects.hash(this.filterId, this.filterString, this.eventClass);
    }

    public String toString() {
        return this.toString;
    }
}

