/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.node;

import com.fluxtion.runtime.audit.EventLogControlEvent;
import com.fluxtion.runtime.audit.EventLogSource;
import com.fluxtion.runtime.audit.EventLogger;
import com.fluxtion.runtime.audit.NullEventLogger;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.util.concurrent.RecursiveTask;

public class ForkedTriggerTask
extends RecursiveTask<Boolean>
implements EventLogSource {
    private final transient String methodName;
    private final LambdaReflection.SerializableSupplier<Boolean> nodeTask;
    private final String delegateName;
    protected EventLogger auditLog = NullEventLogger.INSTANCE;
    private volatile boolean executingInCycle = false;

    public ForkedTriggerTask(LambdaReflection.SerializableSupplier<Boolean> nodeTask, String delegateName) {
        this.nodeTask = nodeTask;
        this.methodName = nodeTask.method().getName();
        this.delegateName = delegateName;
    }

    public void onTrigger() {
        this.executingInCycle = true;
        this.fork();
    }

    public boolean afterEvent() {
        if (this.executingInCycle) {
            this.executingInCycle = false;
            return (Boolean)this.join();
        }
        return this.executingInCycle;
    }

    @Override
    public void reinitialize() {
        this.afterEvent();
        super.reinitialize();
    }

    @Override
    protected Boolean compute() {
        if (this.auditLog.canLog(EventLogControlEvent.LogLevel.DEBUG)) {
            this.auditLog.debug("thread", Thread.currentThread().getName()).debug("delegate", this.delegateName).debug("delegateMethod", this.methodName);
        }
        return (Boolean)this.nodeTask.get();
    }

    @Override
    public void setLogger(EventLogger log) {
        this.auditLog = log;
    }
}

