/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.partition;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongSupplier;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public interface LambdaReflection {
    public static <T> Method getMethod(SerializableConsumer<T> supplier) {
        return supplier.method();
    }

    public static <T, R> Method getMethod(SerializableFunction<T, R> supplier) {
        return supplier.method();
    }

    public static <T, I, R> Method getMethod(SerializableBiFunction<T, I, R> supplier) {
        return supplier.method();
    }

    @FunctionalInterface
    public static interface QuadFunction<F, T, U, V, R> {
        public R apply(F var1, T var2, U var3, V var4);
    }

    @FunctionalInterface
    public static interface TriFunction<F, T, U, R> {
        public R apply(F var1, T var2, U var3);
    }

    @FunctionalInterface
    public static interface LongBinaryPredicate {
        public boolean apply(long var1, long var3);
    }

    @FunctionalInterface
    public static interface DoubleBinaryPredicate {
        public boolean apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface IntBinaryPredicate {
        public boolean apply(int var1, int var2);
    }

    public static interface SerializableQuadFunction<f, t, u, v, r>
    extends QuadFunction<f, t, u, v, r>,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableTriFunction<f, t, u, r>
    extends TriFunction<f, t, u, r>,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableBiLongFunction
    extends LongBinaryOperator,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableBiDoubleFunction
    extends DoubleBinaryOperator,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableBiLongPredicate
    extends LongBinaryPredicate,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableBiDoublePredicate
    extends DoubleBinaryPredicate,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableBiIntPredicate
    extends IntBinaryPredicate,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableBiIntFunction
    extends IntBinaryOperator,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableBiFunction<f, t, r>
    extends BiFunction<f, t, r>,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableDoubleToLongFunction
    extends DoubleToLongFunction,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableIntToLongFunction
    extends IntToLongFunction,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableLongToDoubleFunction
    extends LongToDoubleFunction,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableIntToDoubleFunction
    extends IntToDoubleFunction,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableLongToIntFunction
    extends LongToIntFunction,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableDoubleToIntFunction
    extends DoubleToIntFunction,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableToLongFunction<t>
    extends ToLongFunction<t>,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableToDoubleFunction<t>
    extends ToDoubleFunction<t>,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableLongUnaryOperator
    extends LongUnaryOperator,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableDoubleUnaryOperator
    extends DoubleUnaryOperator,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableIntUnaryOperator
    extends IntUnaryOperator,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableToIntFunction<t>
    extends ToIntFunction<t>,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableLongFunction<r>
    extends LongFunction<r>,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableDoubleFunction<r>
    extends DoubleFunction<r>,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableIntFunction<r>
    extends IntFunction<r>,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableFunction<t, r>
    extends Function<t, r>,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableBiConsumer<t, u>
    extends BiConsumer<t, u>,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableLongConsumer
    extends LongConsumer,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableDoubleConsumer
    extends DoubleConsumer,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableIntConsumer
    extends IntConsumer,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableConsumer<t>
    extends Consumer<t>,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableLongSupplier
    extends LongSupplier,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableDoubleSupplier
    extends DoubleSupplier,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableIntSupplier
    extends IntSupplier,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableSupplier<t>
    extends Supplier<t>,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface SerializableRunnable
    extends Runnable,
    Serializable,
    MethodReferenceReflection {
    }

    public static interface MethodReferenceReflection {
        default public SerializedLambda serialized() {
            try {
                Method replaceMethod = this.getClass().getDeclaredMethod("writeReplace", new Class[0]);
                replaceMethod.setAccessible(true);
                return (SerializedLambda)replaceMethod.invoke((Object)this, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        default public Class<?> getContainingClass(ClassLoader loader) {
            try {
                String className = this.serialized().getImplClass().replaceAll("/", ".");
                return Class.forName(className, true, loader);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        default public Class<?> getContainingClass() {
            try {
                String className = this.serialized().getImplClass().replaceAll("/", ".");
                return Class.forName(className);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        default public Object[] captured() {
            SerializedLambda serialized = this.serialized();
            Object[] args = new Object[serialized.getCapturedArgCount()];
            for (int i = 0; i < serialized.getCapturedArgCount(); ++i) {
                args[i] = serialized.getCapturedArg(i);
            }
            return args;
        }

        default public Method method(ClassLoader loader) {
            SerializedLambda lambda = this.serialized();
            Class<?> containingClass = this.getContainingClass(loader);
            return Arrays.stream(containingClass.getDeclaredMethods()).filter(method -> Objects.equals(method.getName(), lambda.getImplMethodName())).findFirst().orElseThrow(UnableToGuessMethodException::new);
        }

        default public boolean isDefaultConstructor() {
            return this.serialized().getImplMethodName().equalsIgnoreCase("<init>");
        }

        default public Method method() {
            SerializedLambda lambda = this.serialized();
            Class<?> containingClass = this.getContainingClass();
            return Arrays.stream(containingClass.getDeclaredMethods()).filter(method -> Objects.equals(method.getName(), lambda.getImplMethodName())).findFirst().orElseThrow(UnableToGuessMethodException::new);
        }

        public static class UnableToGuessMethodException
        extends RuntimeException {
        }
    }
}

