/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.time;

import com.fluxtion.runtime.annotations.Initialise;
import com.fluxtion.runtime.annotations.NoTriggerReference;
import com.fluxtion.runtime.annotations.OnEventHandler;
import com.fluxtion.runtime.annotations.builder.Inject;
import com.fluxtion.runtime.time.Clock;
import com.fluxtion.runtime.time.ClockStrategy;

public class FixedRateTrigger {
    @Inject
    @NoTriggerReference
    private final Clock clock;
    private final int rate;
    private long previousTime;
    private int triggerCount;

    public static FixedRateTrigger atMillis(int millis) {
        return new FixedRateTrigger(millis);
    }

    public FixedRateTrigger(int rate) {
        this(null, rate);
    }

    public FixedRateTrigger(Clock clock, int rate) {
        this.clock = clock;
        this.rate = rate;
    }

    @OnEventHandler
    public boolean hasExpired(Object input) {
        boolean expired;
        long newTime = this.clock.getWallClockTime();
        boolean bl = expired = (long)this.rate <= newTime - this.previousTime;
        if (expired) {
            this.triggerCount = (int)((newTime - this.previousTime) / (long)this.rate);
            this.previousTime += (long)this.triggerCount * (long)this.rate;
        }
        return expired;
    }

    public int getTriggerCount() {
        return this.triggerCount;
    }

    @OnEventHandler(propagate=false)
    public boolean setClockStrategy(ClockStrategy.ClockStrategyEvent event) {
        this.init();
        return false;
    }

    @Initialise
    public void init() {
        this.previousTime = this.clock.getWallClockTime();
        this.triggerCount = 0;
    }
}

