/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.agrona;

import com.fluxtion.agrona.AsciiEncoding;
import com.fluxtion.agrona.AsciiNumberFormatException;
import com.fluxtion.agrona.BufferUtil;
import com.fluxtion.agrona.DirectBuffer;
import com.fluxtion.agrona.LangUtil;
import com.fluxtion.agrona.MutableDirectBuffer;
import com.fluxtion.agrona.UnsafeAccess;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public abstract class AbstractMutableDirectBuffer
implements MutableDirectBuffer {
    protected byte[] byteArray;
    protected long addressOffset;
    protected int capacity;

    @Override
    public byte[] byteArray() {
        return this.byteArray;
    }

    @Override
    public long addressOffset() {
        return this.addressOffset;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public void checkLimit(int limit) {
        if (limit > this.capacity) {
            throw new IndexOutOfBoundsException("limit=" + limit + " is beyond capacity=" + this.capacity);
        }
    }

    @Override
    public void setMemory(int index, int length, byte value) {
        this.ensureCapacity(index, length);
        byte[] array = this.byteArray;
        long offset = this.addressOffset + (long)index;
        if (length < 100) {
            int i;
            int end = length & 0xFFFFFFF8;
            long mask = (long)value << 56 | ((long)value & 0xFFL) << 48 | ((long)value & 0xFFL) << 40 | ((long)value & 0xFFL) << 32 | ((long)value & 0xFFL) << 24 | ((long)value & 0xFFL) << 16 | ((long)value & 0xFFL) << 8 | (long)value & 0xFFL;
            for (i = 0; i < end; i += 8) {
                UnsafeAccess.UNSAFE.putLong(array, offset + (long)i, mask);
            }
            while (i < length) {
                UnsafeAccess.UNSAFE.putByte(array, offset + (long)i, value);
                ++i;
            }
        } else if (UnsafeAccess.MEMSET_HACK_REQUIRED && length > UnsafeAccess.MEMSET_HACK_THRESHOLD && 0L == (offset & 1L)) {
            UnsafeAccess.UNSAFE.putByte(array, offset, value);
            UnsafeAccess.UNSAFE.setMemory(array, offset + 1L, length - 1, value);
        } else {
            UnsafeAccess.UNSAFE.setMemory(array, offset, length, value);
        }
    }

    @Override
    public long getLong(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        long bits = UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putLong(int index, long value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 8);
        long bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, bits);
    }

    @Override
    public long getLong(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putLong(int index, long value) {
        this.ensureCapacity(index, 8);
        UnsafeAccess.UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public int getInt(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putInt(int index, int value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 4);
        int bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, bits);
    }

    @Override
    public int getInt(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putInt(int index, int value) {
        this.ensureCapacity(index, 4);
        UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public double getDouble(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            long bits = UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset + (long)index);
            return Double.longBitsToDouble(Long.reverseBytes(bits));
        }
        return UnsafeAccess.UNSAFE.getDouble(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putDouble(int index, double value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 8);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            long bits = Long.reverseBytes(Double.doubleToRawLongBits(value));
            UnsafeAccess.UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, bits);
        } else {
            UnsafeAccess.UNSAFE.putDouble(this.byteArray, this.addressOffset + (long)index, value);
        }
    }

    @Override
    public double getDouble(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getDouble(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putDouble(int index, double value) {
        this.ensureCapacity(index, 8);
        UnsafeAccess.UNSAFE.putDouble(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public float getFloat(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
            return Float.intBitsToFloat(Integer.reverseBytes(bits));
        }
        return UnsafeAccess.UNSAFE.getFloat(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putFloat(int index, float value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 4);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            int bits = Integer.reverseBytes(Float.floatToRawIntBits(value));
            UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, bits);
        } else {
            UnsafeAccess.UNSAFE.putFloat(this.byteArray, this.addressOffset + (long)index, value);
        }
    }

    @Override
    public float getFloat(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getFloat(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putFloat(int index, float value) {
        this.ensureCapacity(index, 4);
        UnsafeAccess.UNSAFE.putFloat(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public short getShort(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        short bits = UnsafeAccess.UNSAFE.getShort(this.byteArray, this.addressOffset + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putShort(int index, short value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 2);
        short bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putShort(this.byteArray, this.addressOffset + (long)index, bits);
    }

    @Override
    public short getShort(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        return UnsafeAccess.UNSAFE.getShort(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putShort(int index, short value) {
        this.ensureCapacity(index, 2);
        UnsafeAccess.UNSAFE.putShort(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public byte getByte(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 1);
        }
        return UnsafeAccess.UNSAFE.getByte(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putByte(int index, byte value) {
        this.ensureCapacity(index, 1);
        UnsafeAccess.UNSAFE.putByte(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public void getBytes(int index, byte[] dst) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, dst.length);
            BufferUtil.boundsCheck(dst, 0L, dst.length);
        }
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, dst, BufferUtil.ARRAY_BASE_OFFSET, dst.length);
    }

    @Override
    public void getBytes(int index, byte[] dst, int offset, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
            BufferUtil.boundsCheck(dst, (long)offset, length);
        }
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, dst, BufferUtil.ARRAY_BASE_OFFSET + (long)offset, length);
    }

    @Override
    public void getBytes(int index, MutableDirectBuffer dstBuffer, int dstIndex, int length) {
        dstBuffer.putBytes(dstIndex, this, index, length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dstBuffer, int length) {
        int dstOffset = dstBuffer.position();
        this.getBytes(index, dstBuffer, dstOffset, length);
        dstBuffer.position(dstOffset + length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dstBuffer, int dstOffset, int length) {
        long dstBaseOffset;
        byte[] dstByteArray;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
            BufferUtil.boundsCheck(dstBuffer, (long)dstOffset, length);
        }
        if (dstBuffer.isDirect()) {
            dstByteArray = null;
            dstBaseOffset = BufferUtil.address(dstBuffer);
        } else {
            dstByteArray = BufferUtil.array(dstBuffer);
            dstBaseOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)BufferUtil.arrayOffset(dstBuffer);
        }
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, dstByteArray, dstBaseOffset + (long)dstOffset, length);
    }

    @Override
    public void putBytes(int index, byte[] src) {
        this.ensureCapacity(index, src.length);
        UnsafeAccess.UNSAFE.copyMemory(src, BufferUtil.ARRAY_BASE_OFFSET, this.byteArray, this.addressOffset + (long)index, src.length);
    }

    @Override
    public void putBytes(int index, byte[] src, int offset, int length) {
        this.ensureCapacity(index, length);
        if (SHOULD_BOUNDS_CHECK) {
            BufferUtil.boundsCheck(src, (long)offset, length);
        }
        UnsafeAccess.UNSAFE.copyMemory(src, BufferUtil.ARRAY_BASE_OFFSET + (long)offset, this.byteArray, this.addressOffset + (long)index, length);
    }

    @Override
    public void putBytes(int index, ByteBuffer srcBuffer, int length) {
        int srcIndex = srcBuffer.position();
        this.putBytes(index, srcBuffer, srcIndex, length);
        srcBuffer.position(srcIndex + length);
    }

    @Override
    public void putBytes(int index, ByteBuffer srcBuffer, int srcIndex, int length) {
        long srcBaseOffset;
        byte[] srcByteArray;
        this.ensureCapacity(index, length);
        if (SHOULD_BOUNDS_CHECK) {
            BufferUtil.boundsCheck(srcBuffer, (long)srcIndex, length);
        }
        if (srcBuffer.isDirect()) {
            srcByteArray = null;
            srcBaseOffset = BufferUtil.address(srcBuffer);
        } else {
            srcByteArray = BufferUtil.array(srcBuffer);
            srcBaseOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)BufferUtil.arrayOffset(srcBuffer);
        }
        UnsafeAccess.UNSAFE.copyMemory(srcByteArray, srcBaseOffset + (long)srcIndex, this.byteArray, this.addressOffset + (long)index, length);
    }

    @Override
    public void putBytes(int index, DirectBuffer srcBuffer, int srcIndex, int length) {
        this.ensureCapacity(index, length);
        if (SHOULD_BOUNDS_CHECK) {
            srcBuffer.boundsCheck(srcIndex, length);
        }
        UnsafeAccess.UNSAFE.copyMemory(srcBuffer.byteArray(), srcBuffer.addressOffset() + (long)srcIndex, this.byteArray, this.addressOffset + (long)index, length);
    }

    @Override
    public char getChar(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        char bits = UnsafeAccess.UNSAFE.getChar(this.byteArray, this.addressOffset + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = (char)Short.reverseBytes((short)bits);
        }
        return bits;
    }

    @Override
    public void putChar(int index, char value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 2);
        char bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = (char)Short.reverseBytes((short)bits);
        }
        UnsafeAccess.UNSAFE.putChar(this.byteArray, this.addressOffset + (long)index, bits);
    }

    @Override
    public char getChar(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        return UnsafeAccess.UNSAFE.getChar(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putChar(int index, char value) {
        this.ensureCapacity(index, 2);
        UnsafeAccess.UNSAFE.putChar(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public String getStringAscii(int index) {
        int length;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        if (0 == (length = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index))) {
            return "";
        }
        return this.getStringWithoutLengthAscii(index + 4, length);
    }

    @Override
    public int getStringAscii(int index, Appendable appendable) {
        int length;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        if (0 == (length = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index))) {
            return 0;
        }
        return this.getStringWithoutLengthAscii(index + 4, length, appendable);
    }

    @Override
    public String getStringAscii(int index, ByteOrder byteOrder) {
        int length;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        if (0 == (length = bits)) {
            return "";
        }
        return this.getStringWithoutLengthAscii(index + 4, length);
    }

    @Override
    public int getStringAscii(int index, Appendable appendable, ByteOrder byteOrder) {
        int length;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        if (0 == (length = bits)) {
            return 0;
        }
        return this.getStringWithoutLengthAscii(index + 4, length, appendable);
    }

    @Override
    public String getStringAscii(int index, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index + 4, length);
        }
        if (0 == length) {
            return "";
        }
        byte[] dst = new byte[length];
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index + 4L, dst, BufferUtil.ARRAY_BASE_OFFSET, length);
        return new String(dst, StandardCharsets.US_ASCII);
    }

    @Override
    public int getStringAscii(int index, int length, Appendable appendable) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length + 4);
        }
        try {
            byte[] array = this.byteArray;
            long offset = this.addressOffset;
            int limit = index + 4 + length;
            for (int i = index + 4; i < limit; ++i) {
                char c = (char)UnsafeAccess.UNSAFE.getByte(array, offset + (long)i);
                appendable.append(c > '\u007f' ? (char)'?' : (char)c);
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return length;
    }

    @Override
    public int putStringAscii(int index, String value) {
        if (null == value) {
            this.ensureCapacity(index, 4);
            UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, 0);
            return 4;
        }
        int length = value.length();
        this.ensureCapacity(index, length + 4);
        byte[] array = this.byteArray;
        long offset = this.addressOffset + (long)index;
        UnsafeAccess.UNSAFE.putInt(array, offset, length);
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(array, offset + 4L + (long)i, (byte)c);
        }
        return 4 + length;
    }

    @Override
    public int putStringAscii(int index, CharSequence value) {
        if (null == value) {
            this.ensureCapacity(index, 4);
            UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, 0);
            return 4;
        }
        int length = value.length();
        this.ensureCapacity(index, length + 4);
        byte[] array = this.byteArray;
        long offset = this.addressOffset + (long)index;
        UnsafeAccess.UNSAFE.putInt(array, offset, length);
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(array, offset + 4L + (long)i, (byte)c);
        }
        return 4 + length;
    }

    @Override
    public int putStringAscii(int index, String value, ByteOrder byteOrder) {
        if (null == value) {
            this.ensureCapacity(index, 4);
            UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, 0);
            return 4;
        }
        int length = value.length();
        this.ensureCapacity(index, length + 4);
        int lengthBits = length;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            lengthBits = Integer.reverseBytes(lengthBits);
        }
        byte[] array = this.byteArray;
        long offset = this.addressOffset + (long)index;
        UnsafeAccess.UNSAFE.putInt(array, offset, lengthBits);
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(array, offset + 4L + (long)i, (byte)c);
        }
        return 4 + length;
    }

    @Override
    public int putStringAscii(int index, CharSequence value, ByteOrder byteOrder) {
        if (null == value) {
            this.ensureCapacity(index, 4);
            UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, 0);
            return 4;
        }
        int length = value.length();
        this.ensureCapacity(index, length + 4);
        int lengthBits = length;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            lengthBits = Integer.reverseBytes(lengthBits);
        }
        byte[] array = this.byteArray;
        long offset = this.addressOffset + (long)index;
        UnsafeAccess.UNSAFE.putInt(array, offset, lengthBits);
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(array, offset + 4L + (long)i, (byte)c);
        }
        return 4 + length;
    }

    @Override
    public String getStringWithoutLengthAscii(int index, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        if (0 == length) {
            return "";
        }
        byte[] dst = new byte[length];
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, dst, BufferUtil.ARRAY_BASE_OFFSET, length);
        return new String(dst, StandardCharsets.US_ASCII);
    }

    @Override
    public int getStringWithoutLengthAscii(int index, int length, Appendable appendable) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        try {
            byte[] array = this.byteArray;
            long offset = this.addressOffset;
            int limit = index + length;
            for (int i = index; i < limit; ++i) {
                char c = (char)UnsafeAccess.UNSAFE.getByte(array, offset + (long)i);
                appendable.append(c > '\u007f' ? (char)'?' : (char)c);
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return length;
    }

    @Override
    public int putStringWithoutLengthAscii(int index, String value) {
        if (null == value) {
            return 0;
        }
        int length = value.length();
        this.ensureCapacity(index, length);
        byte[] array = this.byteArray;
        long offset = this.addressOffset + (long)index;
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(array, offset + (long)i, (byte)c);
        }
        return length;
    }

    @Override
    public int putStringWithoutLengthAscii(int index, CharSequence value) {
        if (null == value) {
            return 0;
        }
        int length = value.length();
        this.ensureCapacity(index, length);
        byte[] array = this.byteArray;
        long offset = this.addressOffset + (long)index;
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(array, offset + (long)i, (byte)c);
        }
        return length;
    }

    @Override
    public int putStringWithoutLengthAscii(int index, String value, int valueOffset, int length) {
        if (null == value) {
            return 0;
        }
        int len = Math.min(value.length() - valueOffset, length);
        this.ensureCapacity(index, len);
        byte[] array = this.byteArray;
        long offset = this.addressOffset + (long)index;
        for (int i = 0; i < len; ++i) {
            int c = value.charAt(valueOffset + i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(array, offset + (long)i, (byte)c);
        }
        return len;
    }

    @Override
    public int putStringWithoutLengthAscii(int index, CharSequence value, int valueOffset, int length) {
        if (null == value) {
            return 0;
        }
        int len = Math.min(value.length() - valueOffset, length);
        this.ensureCapacity(index, len);
        byte[] array = this.byteArray;
        long offset = this.addressOffset + (long)index;
        for (int i = 0; i < len; ++i) {
            int c = value.charAt(valueOffset + i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(array, offset + (long)i, (byte)c);
        }
        return len;
    }

    @Override
    public String getStringUtf8(int index) {
        int length;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        if (0 == (length = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index))) {
            return "";
        }
        return this.getStringWithoutLengthUtf8(index + 4, length);
    }

    @Override
    public String getStringUtf8(int index, ByteOrder byteOrder) {
        int length;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        if (0 == (length = bits)) {
            return "";
        }
        return this.getStringWithoutLengthUtf8(index + 4, length);
    }

    @Override
    public String getStringUtf8(int index, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index + 4, length);
        }
        byte[] stringInBytes = new byte[length];
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index + 4L, stringInBytes, BufferUtil.ARRAY_BASE_OFFSET, length);
        return new String(stringInBytes, StandardCharsets.UTF_8);
    }

    @Override
    public int putStringUtf8(int index, String value) {
        return this.putStringUtf8(index, value, Integer.MAX_VALUE);
    }

    @Override
    public int putStringUtf8(int index, String value, ByteOrder byteOrder) {
        return this.putStringUtf8(index, value, byteOrder, Integer.MAX_VALUE);
    }

    @Override
    public int putStringUtf8(int index, String value, int maxEncodedLength) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (bytes.length > maxEncodedLength) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + maxEncodedLength);
        }
        this.ensureCapacity(index, 4 + bytes.length);
        byte[] array = this.byteArray;
        long offset = this.addressOffset + (long)index;
        UnsafeAccess.UNSAFE.putInt(array, offset, bytes.length);
        UnsafeAccess.UNSAFE.copyMemory(bytes, BufferUtil.ARRAY_BASE_OFFSET, array, offset + 4L, bytes.length);
        return 4 + bytes.length;
    }

    @Override
    public int putStringUtf8(int index, String value, ByteOrder byteOrder, int maxEncodedLength) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (bytes.length > maxEncodedLength) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + maxEncodedLength);
        }
        this.ensureCapacity(index, 4 + bytes.length);
        int bits = bytes.length;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        byte[] array = this.byteArray;
        long offset = this.addressOffset + (long)index;
        UnsafeAccess.UNSAFE.putInt(array, offset, bits);
        UnsafeAccess.UNSAFE.copyMemory(bytes, BufferUtil.ARRAY_BASE_OFFSET, array, offset + 4L, bytes.length);
        return 4 + bytes.length;
    }

    @Override
    public String getStringWithoutLengthUtf8(int index, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        if (0 == length) {
            return "";
        }
        byte[] stringInBytes = new byte[length];
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, stringInBytes, BufferUtil.ARRAY_BASE_OFFSET, length);
        return new String(stringInBytes, StandardCharsets.UTF_8);
    }

    @Override
    public int putStringWithoutLengthUtf8(int index, String value) {
        byte[] bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        this.ensureCapacity(index, bytes.length);
        UnsafeAccess.UNSAFE.copyMemory(bytes, BufferUtil.ARRAY_BASE_OFFSET, this.byteArray, this.addressOffset + (long)index, bytes.length);
        return bytes.length;
    }

    @Override
    public int parseNaturalIntAscii(int index, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        if (length <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + index + " length=" + length);
        }
        if (length < 10) {
            return this.parsePositiveIntAscii(index, length, index, index + length);
        }
        long tally = this.parsePositiveIntAsciiOverflowCheck(index, length, index, index + length);
        if (tally >= AsciiEncoding.INTEGER_ABSOLUTE_MIN_VALUE) {
            this.throwParseIntOverflowError(index, length);
        }
        return (int)tally;
    }

    @Override
    public long parseNaturalLongAscii(int index, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        if (length <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + index + " length=" + length);
        }
        if (length < 19) {
            return this.parsePositiveLongAscii(index, length, index, index + length);
        }
        return this.parseLongAsciiOverflowCheck(index, length, AsciiEncoding.LONG_MAX_VALUE_DIGITS, index, index + length);
    }

    @Override
    public int parseIntAscii(int index, int length) {
        int end;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        if (length <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + index + " length=" + length);
        }
        boolean negative = 45 == UnsafeAccess.UNSAFE.getByte(this.byteArray, this.addressOffset + (long)index);
        int i = index;
        if (negative) {
            ++i;
            if (1 == length) {
                this.throwParseIntError(index, length);
            }
        }
        if ((end = index + length) - i < 10) {
            int tally = this.parsePositiveIntAscii(index, length, i, end);
            return negative ? -tally : tally;
        }
        long tally = this.parsePositiveIntAsciiOverflowCheck(index, length, i, end);
        if (tally > AsciiEncoding.INTEGER_ABSOLUTE_MIN_VALUE || AsciiEncoding.INTEGER_ABSOLUTE_MIN_VALUE == tally && !negative) {
            this.throwParseIntOverflowError(index, length);
        }
        return (int)(negative ? -tally : tally);
    }

    @Override
    public long parseLongAscii(int index, int length) {
        int end;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        if (length <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + index + " length=" + length);
        }
        boolean negative = 45 == UnsafeAccess.UNSAFE.getByte(this.byteArray, this.addressOffset + (long)index);
        int i = index;
        if (negative) {
            ++i;
            if (1 == length) {
                this.throwParseLongError(index, length);
            }
        }
        if ((end = index + length) - i < 19) {
            long tally = this.parsePositiveLongAscii(index, length, i, end);
            return negative ? -tally : tally;
        }
        if (negative) {
            return -this.parseLongAsciiOverflowCheck(index, length, AsciiEncoding.LONG_MIN_VALUE_DIGITS, i, end);
        }
        return this.parseLongAsciiOverflowCheck(index, length, AsciiEncoding.LONG_MAX_VALUE_DIGITS, i, end);
    }

    @Override
    public int putIntAscii(int index, int value) {
        long offset;
        byte[] array;
        int length;
        int digitCount;
        if (0 == value) {
            this.putByte(index, (byte)48);
            return 1;
        }
        int quotient = value;
        if (value < 0) {
            if (Integer.MIN_VALUE == value) {
                this.putBytes(index, AsciiEncoding.MIN_INTEGER_VALUE);
                return AsciiEncoding.MIN_INTEGER_VALUE.length;
            }
            quotient = -quotient;
            digitCount = AsciiEncoding.digitCount(quotient);
            length = digitCount + 1;
            this.ensureCapacity(index, length);
            array = this.byteArray;
            offset = this.addressOffset + (long)index;
            UnsafeAccess.UNSAFE.putByte(array, offset, (byte)45);
            ++offset;
        } else {
            length = digitCount = AsciiEncoding.digitCount(quotient);
            this.ensureCapacity(index, length);
            array = this.byteArray;
            offset = this.addressOffset + (long)index;
        }
        AbstractMutableDirectBuffer.putPositiveIntAscii(array, offset, quotient, digitCount);
        return length;
    }

    @Override
    public int putNaturalIntAscii(int index, int value) {
        if (0 == value) {
            this.putByte(index, (byte)48);
            return 1;
        }
        int digitCount = AsciiEncoding.digitCount(value);
        this.ensureCapacity(index, digitCount);
        AbstractMutableDirectBuffer.putPositiveIntAscii(this.byteArray, this.addressOffset + (long)index, value, digitCount);
        return digitCount;
    }

    @Override
    public void putNaturalPaddedIntAscii(int offset, int length, int value) {
        this.ensureCapacity(offset, length);
        byte[] array = this.byteArray;
        long addressOffset = this.addressOffset;
        int end = offset + length;
        int remainder = value;
        for (int index = end - 1; index >= offset; --index) {
            int digit = remainder % 10;
            remainder /= 10;
            UnsafeAccess.UNSAFE.putByte(array, addressOffset + (long)index, (byte)(48 + digit));
        }
        if (remainder != 0) {
            throw new NumberFormatException("Cannot write " + value + " in " + length + " bytes");
        }
    }

    @Override
    public int putNaturalIntAsciiFromEnd(int value, int endExclusive) {
        int length = AsciiEncoding.digitCount(value);
        this.ensureCapacity(endExclusive - length, length);
        byte[] array = this.byteArray;
        long addressOffset = this.addressOffset;
        int index = endExclusive;
        for (int remainder = value; remainder > 0; remainder /= 10) {
            int digit = remainder % 10;
            UnsafeAccess.UNSAFE.putByte(array, addressOffset + (long)(--index), (byte)(48 + digit));
        }
        return index;
    }

    @Override
    public int putNaturalLongAscii(int index, long value) {
        if (0L == value) {
            this.putByte(index, (byte)48);
            return 1;
        }
        int digitCount = AsciiEncoding.digitCount(value);
        this.ensureCapacity(index, digitCount);
        AbstractMutableDirectBuffer.putPositiveLongAscii(this.byteArray, this.addressOffset + (long)index, value, digitCount);
        return digitCount;
    }

    @Override
    public int putLongAscii(int index, long value) {
        long offset;
        byte[] array;
        int length;
        int digitCount;
        if (0L == value) {
            this.putByte(index, (byte)48);
            return 1;
        }
        long quotient = value;
        if (value < 0L) {
            if (Long.MIN_VALUE == value) {
                this.putBytes(index, AsciiEncoding.MIN_LONG_VALUE);
                return AsciiEncoding.MIN_LONG_VALUE.length;
            }
            quotient = -quotient;
            digitCount = AsciiEncoding.digitCount(quotient);
            length = digitCount + 1;
            this.ensureCapacity(index, length);
            array = this.byteArray;
            offset = this.addressOffset + (long)index;
            UnsafeAccess.UNSAFE.putByte(array, offset, (byte)45);
            ++offset;
        } else {
            length = digitCount = AsciiEncoding.digitCount(quotient);
            this.ensureCapacity(index, length);
            array = this.byteArray;
            offset = this.addressOffset + (long)index;
        }
        AbstractMutableDirectBuffer.putPositiveLongAscii(array, offset, quotient, digitCount);
        return length;
    }

    @Override
    public void boundsCheck(int index, int length) {
        this.boundsCheck0(index, length);
    }

    public boolean equals(Object obj) {
        int i;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMutableDirectBuffer that = (AbstractMutableDirectBuffer)obj;
        int length = this.capacity;
        if (length != that.capacity) {
            return false;
        }
        byte[] thisArray = this.byteArray;
        byte[] thatArray = that.byteArray;
        long thisOffset = this.addressOffset;
        long thatOffset = that.addressOffset;
        int end = length & 0xFFFFFFF8;
        for (i = 0; i < end; i += 8) {
            if (UnsafeAccess.UNSAFE.getLong(thisArray, thisOffset + (long)i) == UnsafeAccess.UNSAFE.getLong(thatArray, thatOffset + (long)i)) continue;
            return false;
        }
        while (i < length) {
            if (UnsafeAccess.UNSAFE.getByte(thisArray, thisOffset + (long)i) != UnsafeAccess.UNSAFE.getByte(thatArray, thatOffset + (long)i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int i;
        byte[] array = this.byteArray;
        long addressOffset = this.addressOffset;
        int length = this.capacity;
        int hashCode = 19;
        int end = length & 0xFFFFFFF8;
        for (i = 0; i < end; i += 8) {
            hashCode = 31 * hashCode + Long.hashCode(UnsafeAccess.UNSAFE.getLong(array, addressOffset + (long)i));
        }
        while (i < length) {
            hashCode = 31 * hashCode + UnsafeAccess.UNSAFE.getByte(array, addressOffset + (long)i);
            ++i;
        }
        return hashCode;
    }

    @Override
    public int compareTo(DirectBuffer that) {
        int i;
        if (this == that) {
            return 0;
        }
        int thisCapacity = this.capacity;
        int thatCapacity = that.capacity();
        byte[] thisArray = this.byteArray;
        byte[] thatArray = that.byteArray();
        long thisOffset = this.addressOffset;
        long thatOffset = that.addressOffset();
        int length = Math.min(thisCapacity, thatCapacity);
        int end = length & 0xFFFFFFF8;
        for (i = 0; i < end; i += 8) {
            int cmp = Long.compare(UnsafeAccess.UNSAFE.getLong(thisArray, thisOffset + (long)i), UnsafeAccess.UNSAFE.getLong(thatArray, thatOffset + (long)i));
            if (0 == cmp) continue;
            return cmp;
        }
        while (i < length) {
            int cmp = Byte.compare(UnsafeAccess.UNSAFE.getByte(thisArray, thisOffset + (long)i), UnsafeAccess.UNSAFE.getByte(thatArray, thatOffset + (long)i));
            if (0 != cmp) {
                return cmp;
            }
            ++i;
        }
        return Integer.compare(thisCapacity, thatCapacity);
    }

    protected final void boundsCheck0(int index, int length) {
        long resultingPosition = (long)index + (long)length;
        if (index < 0 || length < 0 || resultingPosition > (long)this.capacity) {
            throw new IndexOutOfBoundsException("index=" + index + " length=" + length + " capacity=" + this.capacity);
        }
    }

    protected abstract void ensureCapacity(int var1, int var2);

    private int parsePositiveIntAscii(int index, int length, int startIndex, int end) {
        byte digit;
        int quartet;
        long offset = this.addressOffset;
        byte[] array = this.byteArray;
        int i = startIndex;
        int tally = 0;
        while (end - i >= 4 && AsciiEncoding.isFourDigitsAsciiEncodedNumber(quartet = UnsafeAccess.UNSAFE.getInt(array, offset + (long)i))) {
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                quartet = Integer.reverseBytes(quartet);
            }
            tally = tally * 10000 + AsciiEncoding.parseFourDigitsLittleEndian(quartet);
            i += 4;
        }
        while (i < end && AsciiEncoding.isDigit(digit = UnsafeAccess.UNSAFE.getByte(array, offset + (long)i))) {
            tally = tally * 10 + (digit - 48);
            ++i;
        }
        if (i != end) {
            this.throwParseIntError(index, length);
        }
        return tally;
    }

    private long parsePositiveIntAsciiOverflowCheck(int index, int length, int startIndex, int end) {
        if (end - startIndex > 10) {
            this.throwParseIntOverflowError(index, length);
        }
        long offset = this.addressOffset;
        byte[] array = this.byteArray;
        int i = startIndex;
        long tally = 0L;
        long octet = UnsafeAccess.UNSAFE.getLong(array, offset + (long)i);
        if (AsciiEncoding.isEightDigitAsciiEncodedNumber(octet)) {
            byte digit;
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                octet = Long.reverseBytes(octet);
            }
            tally = AsciiEncoding.parseEightDigitsLittleEndian(octet);
            i += 8;
            while (i < end && AsciiEncoding.isDigit(digit = UnsafeAccess.UNSAFE.getByte(array, offset + (long)i))) {
                tally = tally * 10L + (long)(digit - 48);
                ++i;
            }
        }
        if (i != end) {
            this.throwParseIntError(index, length);
        }
        return tally;
    }

    private void throwParseIntError(int index, int length) {
        throw new AsciiNumberFormatException("error parsing int: " + this.getStringWithoutLengthAscii(index, length));
    }

    private void throwParseIntOverflowError(int index, int length) {
        throw new AsciiNumberFormatException("int overflow parsing: " + this.getStringWithoutLengthAscii(index, length));
    }

    private long parsePositiveLongAscii(int index, int length, int startIndex, int end) {
        byte digit;
        int quartet;
        long octet;
        long offset = this.addressOffset;
        byte[] array = this.byteArray;
        int i = startIndex;
        long tally = 0L;
        while (end - i >= 8 && AsciiEncoding.isEightDigitAsciiEncodedNumber(octet = UnsafeAccess.UNSAFE.getLong(array, offset + (long)i))) {
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                octet = Long.reverseBytes(octet);
            }
            tally = tally * 100000000L + (long)AsciiEncoding.parseEightDigitsLittleEndian(octet);
            i += 8;
        }
        while (end - i >= 4 && AsciiEncoding.isFourDigitsAsciiEncodedNumber(quartet = UnsafeAccess.UNSAFE.getInt(array, offset + (long)i))) {
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                quartet = Integer.reverseBytes(quartet);
            }
            tally = tally * 10000L + (long)AsciiEncoding.parseFourDigitsLittleEndian(quartet);
            i += 4;
        }
        while (i < end && AsciiEncoding.isDigit(digit = UnsafeAccess.UNSAFE.getByte(array, offset + (long)i))) {
            tally = tally * 10L + (long)(digit - 48);
            ++i;
        }
        if (i != end) {
            this.throwParseLongError(index, length);
        }
        return tally;
    }

    private long parseLongAsciiOverflowCheck(int index, int length, int[] maxValue, int startIndex, int end) {
        byte digit;
        long octet;
        if (end - startIndex > 19) {
            this.throwParseLongOverflowError(index, length);
        }
        long offset = this.addressOffset;
        byte[] array = this.byteArray;
        int i = startIndex;
        int k = 0;
        boolean checkOverflow = true;
        long tally = 0L;
        while (end - i >= 8 && AsciiEncoding.isEightDigitAsciiEncodedNumber(octet = UnsafeAccess.UNSAFE.getLong(array, offset + (long)i))) {
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                octet = Long.reverseBytes(octet);
            }
            int eightDigits = AsciiEncoding.parseEightDigitsLittleEndian(octet);
            if (checkOverflow) {
                if (eightDigits > maxValue[k]) {
                    this.throwParseLongOverflowError(index, length);
                } else if (eightDigits < maxValue[k]) {
                    checkOverflow = false;
                }
                ++k;
            }
            tally = tally * 100000000L + (long)eightDigits;
            i += 8;
        }
        int lastDigits = 0;
        while (i < end && AsciiEncoding.isDigit(digit = UnsafeAccess.UNSAFE.getByte(array, offset + (long)i))) {
            lastDigits = lastDigits * 10 + (digit - 48);
            ++i;
        }
        if (i != end) {
            this.throwParseLongError(index, length);
        } else if (checkOverflow && lastDigits > maxValue[k]) {
            this.throwParseLongOverflowError(index, length);
        }
        return tally * 1000L + (long)lastDigits;
    }

    private void throwParseLongError(int index, int length) {
        throw new AsciiNumberFormatException("error parsing long: " + this.getStringWithoutLengthAscii(index, length));
    }

    private void throwParseLongOverflowError(int index, int length) {
        throw new AsciiNumberFormatException("long overflow parsing: " + this.getStringWithoutLengthAscii(index, length));
    }

    private static void putPositiveIntAscii(byte[] dest, long offset, int value, int digitCount) {
        int position;
        int quotient;
        int i = digitCount;
        for (quotient = value; quotient >= 10000; quotient /= 10000) {
            int lastFourDigits = quotient % 10000;
            int p1 = lastFourDigits / 100 << 1;
            int p2 = lastFourDigits % 100 << 1;
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)(i -= 4), AsciiEncoding.ASCII_DIGITS[p1]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 1L, AsciiEncoding.ASCII_DIGITS[p1 + 1]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 2L, AsciiEncoding.ASCII_DIGITS[p2]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 3L, AsciiEncoding.ASCII_DIGITS[p2 + 1]);
        }
        if (quotient >= 100) {
            position = quotient % 100 << 1;
            quotient /= 100;
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i - 1L, AsciiEncoding.ASCII_DIGITS[position + 1]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i - 2L, AsciiEncoding.ASCII_DIGITS[position]);
        }
        if (quotient >= 10) {
            position = quotient << 1;
            UnsafeAccess.UNSAFE.putByte(dest, offset + 1L, AsciiEncoding.ASCII_DIGITS[position + 1]);
            UnsafeAccess.UNSAFE.putByte(dest, offset, AsciiEncoding.ASCII_DIGITS[position]);
        } else {
            UnsafeAccess.UNSAFE.putByte(dest, offset, (byte)(48 + quotient));
        }
    }

    private static void putPositiveLongAscii(byte[] dest, long offset, long value, int digitCount) {
        long quotient;
        int i = digitCount;
        for (quotient = value; quotient >= 100000000L; quotient /= 100000000L) {
            int lastEightDigits = (int)(quotient % 100000000L);
            int upperPart = lastEightDigits / 10000;
            int lowerPart = lastEightDigits % 10000;
            int u1 = upperPart / 100 << 1;
            int u2 = upperPart % 100 << 1;
            int l1 = lowerPart / 100 << 1;
            int l2 = lowerPart % 100 << 1;
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)(i -= 8), AsciiEncoding.ASCII_DIGITS[u1]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 1L, AsciiEncoding.ASCII_DIGITS[u1 + 1]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 2L, AsciiEncoding.ASCII_DIGITS[u2]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 3L, AsciiEncoding.ASCII_DIGITS[u2 + 1]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 4L, AsciiEncoding.ASCII_DIGITS[l1]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 5L, AsciiEncoding.ASCII_DIGITS[l1 + 1]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 6L, AsciiEncoding.ASCII_DIGITS[l2]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 7L, AsciiEncoding.ASCII_DIGITS[l2 + 1]);
        }
        AbstractMutableDirectBuffer.putPositiveIntAscii(dest, offset, (int)quotient, i);
    }
}

