/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.agrona.concurrent;

import com.fluxtion.agrona.concurrent.BackoffIdleStrategyData;
import com.fluxtion.agrona.concurrent.IdleStrategy;
import com.fluxtion.agrona.hints.ThreadHints;
import java.util.concurrent.locks.LockSupport;

public final class BackoffIdleStrategy
extends BackoffIdleStrategyData
implements IdleStrategy {
    public static final String ALIAS = "backoff";
    public static final long DEFAULT_MAX_SPINS = 10L;
    public static final long DEFAULT_MAX_YIELDS = 5L;
    public static final long DEFAULT_MIN_PARK_PERIOD_NS = 1000L;
    public static final long DEFAULT_MAX_PARK_PERIOD_NS = 1000000L;
    byte p064;
    byte p065;
    byte p066;
    byte p067;
    byte p068;
    byte p069;
    byte p070;
    byte p071;
    byte p072;
    byte p073;
    byte p074;
    byte p075;
    byte p076;
    byte p077;
    byte p078;
    byte p079;
    byte p080;
    byte p081;
    byte p082;
    byte p083;
    byte p084;
    byte p085;
    byte p086;
    byte p087;
    byte p088;
    byte p089;
    byte p090;
    byte p091;
    byte p092;
    byte p093;
    byte p094;
    byte p095;
    byte p096;
    byte p097;
    byte p098;
    byte p099;
    byte p100;
    byte p101;
    byte p102;
    byte p103;
    byte p104;
    byte p105;
    byte p106;
    byte p107;
    byte p108;
    byte p109;
    byte p110;
    byte p111;
    byte p112;
    byte p113;
    byte p114;
    byte p115;
    byte p116;
    byte p117;
    byte p118;
    byte p119;
    byte p120;
    byte p121;
    byte p122;
    byte p123;
    byte p124;
    byte p125;
    byte p126;
    byte p127;

    public BackoffIdleStrategy() {
        super(10L, 5L, 1000L, 1000000L);
    }

    public BackoffIdleStrategy(long maxSpins, long maxYields, long minParkPeriodNs, long maxParkPeriodNs) {
        super(maxSpins, maxYields, minParkPeriodNs, maxParkPeriodNs);
    }

    @Override
    public void idle(int workCount) {
        if (workCount > 0) {
            this.reset();
        } else {
            this.idle();
        }
    }

    @Override
    public void idle() {
        switch (this.state) {
            case 0: {
                this.state = 1;
                ++this.spins;
                break;
            }
            case 1: {
                ThreadHints.onSpinWait();
                if (++this.spins <= this.maxSpins) break;
                this.state = 2;
                this.yields = 0L;
                break;
            }
            case 2: {
                if (++this.yields > this.maxYields) {
                    this.state = 3;
                    this.parkPeriodNs = this.minParkPeriodNs;
                    break;
                }
                Thread.yield();
                break;
            }
            case 3: {
                LockSupport.parkNanos(this.parkPeriodNs);
                this.parkPeriodNs = Math.min(this.parkPeriodNs << 1, this.maxParkPeriodNs);
            }
        }
    }

    @Override
    public void reset() {
        this.spins = 0L;
        this.yields = 0L;
        this.parkPeriodNs = this.minParkPeriodNs;
        this.state = 0;
    }

    @Override
    public String alias() {
        return ALIAS;
    }

    public String toString() {
        return "BackoffIdleStrategy{alias=backoff, maxSpins=" + this.maxSpins + ", maxYields=" + this.maxYields + ", minParkPeriodNs=" + this.minParkPeriodNs + ", maxParkPeriodNs=" + this.maxParkPeriodNs + '}';
    }
}

