/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.agrona.concurrent;

import com.fluxtion.agrona.concurrent.AtomicBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public class RecordBuffer {
    public static final int DID_NOT_CLAIM_RECORD = -1;
    private static final int UNUSED = 0;
    private static final int PENDING = 1;
    private static final int COMMITTED = 2;
    private static final int SIZE_OF_POSITION_FIELD = 4;
    private static final int SIZE_OF_STATUS_FIELD = 4;
    private static final int SIZE_OF_KEY_FIELD = 4;
    private static final int SIZE_OF_RECORD_FRAME = 8;
    private static final long PAUSE_TIME_NS = TimeUnit.MICROSECONDS.toNanos(1000L);
    private final AtomicBuffer buffer;
    private final int positionFieldOffset;
    private final int endOfPositionField;
    private final int slotSize;

    public RecordBuffer(AtomicBuffer buffer, int headerSize, int recordSize) {
        this.buffer = buffer;
        this.positionFieldOffset = headerSize;
        this.endOfPositionField = headerSize + 4;
        this.slotSize = recordSize + 8;
    }

    public void initialise() {
        this.movePosition(this.endOfPositionField);
    }

    public boolean isInitialised() {
        return this.position() != 0;
    }

    public void forEach(RecordHandler handler) {
        int position = this.position();
        for (int offset = this.endOfPositionField; offset < position; offset += this.slotSize) {
            if (this.statusVolatile(offset) != 2) continue;
            int key = this.key(offset);
            handler.onRecord(key, offset + 8);
        }
    }

    public int get(int key) {
        int position = this.position();
        for (int offset = this.endOfPositionField; offset < position; offset += this.slotSize) {
            if (this.statusVolatile(offset) != 2 || key != this.key(offset)) continue;
            return offset + 8;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean withRecord(int key, RecordWriter writer) {
        int claimedOffset = this.claimRecord(key);
        if (claimedOffset == -1) {
            return false;
        }
        try {
            writer.writeRecord(claimedOffset);
        }
        finally {
            this.commit(claimedOffset);
        }
        return true;
    }

    public int claimRecord(int key) {
        int offset;
        for (offset = this.endOfPositionField; offset < this.position(); offset += this.slotSize) {
            if (key != this.key(offset)) continue;
            if (this.statusVolatile(offset) == 1) {
                return -1;
            }
            this.compareAndSetStatus(offset, 2, 1);
            return offset + 8;
        }
        if (offset + this.slotSize > this.buffer.capacity()) {
            return -1;
        }
        int claimOffset = this.movePosition(this.slotSize);
        this.compareAndSetStatus(claimOffset, 0, 1);
        this.key(claimOffset, key);
        return claimOffset + 8;
    }

    public void commit(int claimedOffset) {
        this.compareAndSetStatus(claimedOffset - 8, 1, 2);
    }

    private int statusVolatile(int offset) {
        return this.buffer.getIntVolatile(offset);
    }

    private void compareAndSetStatus(int offset, int oldStatus, int newStatus) {
        while (!this.buffer.compareAndSetInt(offset, oldStatus, newStatus)) {
            LockSupport.parkNanos(PAUSE_TIME_NS);
        }
    }

    private int key(int offset) {
        return this.buffer.getInt(offset + 4);
    }

    private void key(int offset, int key) {
        this.buffer.putInt(offset + 4, key);
    }

    private int position() {
        return this.buffer.getIntVolatile(this.positionFieldOffset);
    }

    private int movePosition(int delta) {
        return this.buffer.getAndAddInt(this.positionFieldOffset, delta);
    }

    public static interface RecordWriter {
        public void writeRecord(int var1);
    }

    public static interface RecordHandler {
        public void onRecord(int var1, int var2);
    }
}

