/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.agrona.concurrent.errors;

import com.fluxtion.agrona.BitUtil;
import com.fluxtion.agrona.concurrent.AtomicBuffer;
import com.fluxtion.agrona.concurrent.errors.ErrorConsumer;

public class ErrorLogReader {
    public static boolean hasErrors(AtomicBuffer buffer) {
        return buffer.capacity() >= 4 && buffer.getIntVolatile(0) > 0;
    }

    public static int read(AtomicBuffer buffer, ErrorConsumer consumer) {
        return ErrorLogReader.read(buffer, consumer, 0L);
    }

    public static int read(AtomicBuffer buffer, ErrorConsumer consumer, long sinceTimestamp) {
        int length;
        int entries = 0;
        int capacity = buffer.capacity();
        for (int offset = 0; offset <= capacity - 24 && (length = Math.min(buffer.getIntVolatile(offset + 0), capacity - offset)) > 0; offset += BitUtil.align(length, 8)) {
            long lastObservationTimestamp = buffer.getLongVolatile(offset + 8);
            if (lastObservationTimestamp < sinceTimestamp) continue;
            ++entries;
            consumer.accept(buffer.getInt(offset + 4), buffer.getLong(offset + 16), lastObservationTimestamp, buffer.getStringWithoutLengthUtf8(offset + 24, length - 24));
        }
        return entries;
    }
}

