/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.agrona.concurrent.ringbuffer;

import com.fluxtion.agrona.BitUtil;

public final class RingBufferDescriptor {
    public static final int TAIL_POSITION_OFFSET;
    public static final int HEAD_CACHE_POSITION_OFFSET;
    public static final int HEAD_POSITION_OFFSET;
    public static final int CORRELATION_COUNTER_OFFSET;
    public static final int CONSUMER_HEARTBEAT_OFFSET;
    public static final int TRAILER_LENGTH;

    private RingBufferDescriptor() {
    }

    public static int checkCapacity(int capacity, int minCapacity) {
        int dataCapacity = capacity - TRAILER_LENGTH;
        if (!BitUtil.isPowerOfTwo(dataCapacity)) {
            throw new IllegalArgumentException("capacity must be a positive power of 2 + TRAILER_LENGTH: capacity=" + capacity);
        }
        if (dataCapacity < minCapacity) {
            throw new IllegalArgumentException("insufficient capacity: minCapacity=" + (minCapacity + TRAILER_LENGTH) + ", capacity=" + capacity);
        }
        return dataCapacity;
    }

    static {
        int offset = 0;
        TAIL_POSITION_OFFSET = offset += 128;
        HEAD_CACHE_POSITION_OFFSET = offset += 128;
        HEAD_POSITION_OFFSET = offset += 128;
        CORRELATION_COUNTER_OFFSET = offset += 128;
        CONSUMER_HEARTBEAT_OFFSET = offset += 128;
        TRAILER_LENGTH = offset += 128;
    }
}

