/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.agrona.concurrent.status;

import com.fluxtion.agrona.DirectBuffer;
import com.fluxtion.agrona.LangUtil;
import com.fluxtion.agrona.MutableDirectBuffer;
import com.fluxtion.agrona.collections.IntArrayList;
import com.fluxtion.agrona.concurrent.AtomicBuffer;
import com.fluxtion.agrona.concurrent.CachedEpochClock;
import com.fluxtion.agrona.concurrent.EpochClock;
import com.fluxtion.agrona.concurrent.UnsafeBuffer;
import com.fluxtion.agrona.concurrent.status.AtomicCounter;
import com.fluxtion.agrona.concurrent.status.CountersReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;

public class CountersManager
extends CountersReader {
    private final long freeToReuseTimeoutMs;
    private int highWaterMarkId = -1;
    private final IntArrayList freeList = new IntArrayList();
    private final EpochClock epochClock;

    public CountersManager(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer, Charset labelCharset, EpochClock epochClock, long freeToReuseTimeoutMs) {
        super(metaDataBuffer, valuesBuffer, labelCharset);
        valuesBuffer.verifyAlignment();
        this.epochClock = epochClock;
        this.freeToReuseTimeoutMs = freeToReuseTimeoutMs;
        if (metaDataBuffer.capacity() < valuesBuffer.capacity() * 4) {
            throw new IllegalArgumentException("metadata buffer is too small");
        }
    }

    public CountersManager(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer, Charset labelCharset) {
        this(metaDataBuffer, valuesBuffer, labelCharset, new CachedEpochClock(), 0L);
    }

    public CountersManager(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer) {
        this(metaDataBuffer, valuesBuffer, StandardCharsets.UTF_8, new CachedEpochClock(), 0L);
    }

    public int capacity() {
        return this.maxCounterId + 1;
    }

    public int available() {
        int freeListCount = 0;
        if (!this.freeList.isEmpty()) {
            long nowMs = this.epochClock.time();
            int size = this.freeList.size();
            for (int i = 0; i < size; ++i) {
                int counterId = this.freeList.getInt(i);
                if (nowMs < this.metaDataBuffer.getLong(CountersManager.metaDataOffset(counterId) + 8)) continue;
                ++freeListCount;
            }
        }
        return this.capacity() - this.highWaterMarkId - 1 + freeListCount;
    }

    public int allocate(String label) {
        return this.allocate(label, 0);
    }

    public int allocate(String label, int typeId) {
        int counterId = this.nextCounterId();
        int recordOffset = CountersManager.metaDataOffset(counterId);
        try {
            this.metaDataBuffer.putInt(recordOffset + 4, typeId);
            this.metaDataBuffer.putLong(recordOffset + 8, Long.MAX_VALUE);
            this.putLabel(recordOffset, label);
            this.metaDataBuffer.putIntOrdered(recordOffset, 1);
        }
        catch (Exception ex) {
            this.freeList.pushInt(counterId);
            LangUtil.rethrowUnchecked(ex);
        }
        return counterId;
    }

    public int allocate(String label, int typeId, Consumer<MutableDirectBuffer> keyFunc) {
        int counterId = this.nextCounterId();
        try {
            int recordOffset = CountersManager.metaDataOffset(counterId);
            this.metaDataBuffer.putInt(recordOffset + 4, typeId);
            keyFunc.accept(new UnsafeBuffer(this.metaDataBuffer, recordOffset + 16, 112));
            this.metaDataBuffer.putLong(recordOffset + 8, Long.MAX_VALUE);
            this.putLabel(recordOffset, label);
            this.metaDataBuffer.putIntOrdered(recordOffset, 1);
        }
        catch (Exception ex) {
            this.freeList.pushInt(counterId);
            LangUtil.rethrowUnchecked(ex);
        }
        return counterId;
    }

    public int allocate(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        int counterId = this.nextCounterId();
        try {
            int length;
            int recordOffset = CountersManager.metaDataOffset(counterId);
            this.metaDataBuffer.putInt(recordOffset + 4, typeId);
            this.metaDataBuffer.putLong(recordOffset + 8, Long.MAX_VALUE);
            if (null != keyBuffer) {
                length = Math.min(keyLength, 112);
                this.metaDataBuffer.putBytes(recordOffset + 16, keyBuffer, keyOffset, length);
            }
            length = Math.min(labelLength, 380);
            this.metaDataBuffer.putInt(recordOffset + 128, length);
            this.metaDataBuffer.putBytes(recordOffset + 128 + 4, labelBuffer, labelOffset, length);
            this.metaDataBuffer.putIntOrdered(recordOffset, 1);
        }
        catch (Exception ex) {
            this.freeList.pushInt(counterId);
            LangUtil.rethrowUnchecked(ex);
        }
        return counterId;
    }

    public AtomicCounter newCounter(String label) {
        return new AtomicCounter(this.valuesBuffer, this.allocate(label), this);
    }

    public AtomicCounter newCounter(String label, int typeId) {
        return new AtomicCounter(this.valuesBuffer, this.allocate(label, typeId), this);
    }

    public AtomicCounter newCounter(String label, int typeId, Consumer<MutableDirectBuffer> keyFunc) {
        return new AtomicCounter(this.valuesBuffer, this.allocate(label, typeId, keyFunc), this);
    }

    public AtomicCounter newCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        return new AtomicCounter(this.valuesBuffer, this.allocate(typeId, keyBuffer, keyOffset, keyLength, labelBuffer, labelOffset, labelLength), this);
    }

    public void free(int counterId) {
        this.validateCounterId(counterId);
        int offset = CountersManager.metaDataOffset(counterId);
        if (1 != this.metaDataBuffer.getIntVolatile(offset)) {
            throw new IllegalStateException("counter not allocated: id=" + counterId);
        }
        this.metaDataBuffer.putIntOrdered(offset, -1);
        this.metaDataBuffer.setMemory(offset + 16, 112, (byte)0);
        this.metaDataBuffer.putLong(offset + 8, this.epochClock.time() + this.freeToReuseTimeoutMs);
        this.freeList.addInt(counterId);
    }

    public void setCounterValue(int counterId, long value) {
        this.validateCounterId(counterId);
        this.valuesBuffer.putLongOrdered(CountersManager.counterOffset(counterId), value);
    }

    public void setCounterRegistrationId(int counterId, long registrationId) {
        this.validateCounterId(counterId);
        this.valuesBuffer.putLongOrdered(CountersManager.counterOffset(counterId) + 8, registrationId);
    }

    public void setCounterOwnerId(int counterId, long ownerId) {
        this.validateCounterId(counterId);
        this.valuesBuffer.putLong(CountersManager.counterOffset(counterId) + 16, ownerId);
    }

    public void setCounterReferenceId(int counterId, long referenceId) {
        this.validateCounterId(counterId);
        this.valuesBuffer.putLong(CountersManager.counterOffset(counterId) + 24, referenceId);
    }

    public void setCounterLabel(int counterId, String label) {
        this.validateCounterId(counterId);
        this.putLabel(CountersManager.metaDataOffset(counterId), label);
    }

    public void setCounterKey(int counterId, Consumer<MutableDirectBuffer> keyFunc) {
        this.validateCounterId(counterId);
        keyFunc.accept(new UnsafeBuffer(this.metaDataBuffer, CountersManager.metaDataOffset(counterId) + 16, 112));
    }

    public void setCounterKey(int counterId, DirectBuffer keyBuffer, int offset, int length) {
        this.validateCounterId(counterId);
        if (length > 112) {
            throw new IllegalArgumentException("key is too long: " + length + ", max: " + 112);
        }
        this.metaDataBuffer.putBytes(CountersManager.metaDataOffset(counterId) + 16, keyBuffer, offset, length);
    }

    public void appendToLabel(int counterId, String label) {
        this.appendLabel(CountersManager.metaDataOffset(counterId), label);
    }

    public String toString() {
        return "CountersManager{freeToReuseTimeoutMs=" + this.freeToReuseTimeoutMs + ", highWaterMarkId=" + this.highWaterMarkId + ", freeList=" + this.freeList + ", epochClock=" + this.epochClock + '}';
    }

    private int nextCounterId() {
        if (!this.freeList.isEmpty()) {
            long nowMs = this.epochClock.time();
            int size = this.freeList.size();
            for (int i = 0; i < size; ++i) {
                int counterId = this.freeList.getInt(i);
                if (nowMs < this.metaDataBuffer.getLong(CountersManager.metaDataOffset(counterId) + 8)) continue;
                this.freeList.remove(i);
                int offset = CountersManager.counterOffset(counterId);
                this.valuesBuffer.putLongOrdered(offset + 8, 0L);
                this.valuesBuffer.putLong(offset + 16, 0L);
                this.valuesBuffer.putLong(offset + 24, 0L);
                this.valuesBuffer.putLongOrdered(offset, 0L);
                return counterId;
            }
        }
        this.checkCountersCapacity(this.highWaterMarkId + 1);
        return ++this.highWaterMarkId;
    }

    private void putLabel(int recordOffset, String label) {
        if (StandardCharsets.US_ASCII == this.labelCharset) {
            int length = this.metaDataBuffer.putStringWithoutLengthAscii(recordOffset + 128 + 4, label, 0, 380);
            this.metaDataBuffer.putIntOrdered(recordOffset + 128, length);
        } else {
            byte[] bytes = label.getBytes(this.labelCharset);
            int length = Math.min(bytes.length, 380);
            this.metaDataBuffer.putBytes(recordOffset + 128 + 4, bytes, 0, length);
            this.metaDataBuffer.putIntOrdered(recordOffset + 128, length);
        }
    }

    private void appendLabel(int recordOffset, String suffix) {
        int existingLength = this.metaDataBuffer.getInt(recordOffset + 128);
        int maxSuffixLength = 380 - existingLength;
        if (StandardCharsets.US_ASCII == this.labelCharset) {
            int suffixLength = this.metaDataBuffer.putStringWithoutLengthAscii(recordOffset + 128 + 4 + existingLength, suffix, 0, maxSuffixLength);
            this.metaDataBuffer.putIntOrdered(recordOffset + 128, existingLength + suffixLength);
        } else {
            byte[] suffixBytes = suffix.getBytes(this.labelCharset);
            int suffixLength = Math.min(suffixBytes.length, maxSuffixLength);
            this.metaDataBuffer.putBytes(recordOffset + 128 + 4 + existingLength, suffixBytes, 0, suffixLength);
            this.metaDataBuffer.putIntOrdered(recordOffset + 128, existingLength + suffixLength);
        }
    }

    private void checkCountersCapacity(int counterId) {
        if (counterId > this.maxCounterId) {
            throw new IllegalStateException("unable to allocate counter, buffer is full: maxCounterId=" + this.maxCounterId);
        }
    }
}

