/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.agrona.concurrent.status;

import com.fluxtion.agrona.UnsafeAccess;
import com.fluxtion.agrona.concurrent.AtomicBuffer;
import com.fluxtion.agrona.concurrent.status.CountersManager;
import com.fluxtion.agrona.concurrent.status.StatusIndicator;
import java.nio.ByteBuffer;

public class UnsafeBufferStatusIndicator
extends StatusIndicator {
    private final int counterId;
    private final long addressOffset;
    private final byte[] byteArray;
    private final ByteBuffer byteBuffer;

    public UnsafeBufferStatusIndicator(AtomicBuffer buffer, int counterId) {
        this.counterId = counterId;
        this.byteArray = buffer.byteArray();
        this.byteBuffer = buffer.byteBuffer();
        int counterOffset = CountersManager.counterOffset(counterId);
        buffer.boundsCheck(counterOffset, 8);
        this.addressOffset = buffer.addressOffset() + (long)counterOffset;
    }

    @Override
    public int id() {
        return this.counterId;
    }

    @Override
    public void setOrdered(long value) {
        UnsafeAccess.UNSAFE.putOrderedLong(this.byteArray, this.addressOffset, value);
    }

    @Override
    public long getVolatile() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this.byteArray, this.addressOffset);
    }

    public String toString() {
        return "UnsafeBufferStatusIndicator{counterId=" + this.counterId + "value=" + this.getVolatile() + '}';
    }
}

