/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime;

import com.fluxtion.runtime.EventProcessor;
import com.fluxtion.runtime.StaticEventProcessor;
import com.fluxtion.runtime.annotations.OnEventHandler;
import com.fluxtion.runtime.audit.Auditor;
import com.fluxtion.runtime.audit.EventLogManager;
import com.fluxtion.runtime.audit.NodeNameAuditor;
import com.fluxtion.runtime.callback.CallbackDispatcherImpl;
import com.fluxtion.runtime.callback.ExportFunctionAuditEvent;
import com.fluxtion.runtime.callback.InternalEventProcessor;
import com.fluxtion.runtime.event.Event;
import com.fluxtion.runtime.input.EventFeed;
import com.fluxtion.runtime.input.SubscriptionManager;
import com.fluxtion.runtime.input.SubscriptionManagerNode;
import com.fluxtion.runtime.lifecycle.BatchHandler;
import com.fluxtion.runtime.lifecycle.Lifecycle;
import com.fluxtion.runtime.node.MutableEventProcessorContext;
import com.fluxtion.runtime.node.ObjectEventHandlerNode;
import com.fluxtion.runtime.service.Service;
import com.fluxtion.runtime.service.ServiceListener;
import com.fluxtion.runtime.service.ServiceRegistryNode;
import com.fluxtion.runtime.time.Clock;
import com.fluxtion.runtime.time.ClockStrategy;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

public class DefaultEventProcessor
implements EventProcessor<DefaultEventProcessor>,
ServiceListener,
StaticEventProcessor,
InternalEventProcessor,
BatchHandler,
Lifecycle {
    private final transient CallbackDispatcherImpl callbackDispatcher = new CallbackDispatcherImpl();
    public final transient Clock clock = new Clock();
    public final transient NodeNameAuditor nodeNameLookup = new NodeNameAuditor();
    private final transient SubscriptionManagerNode subscriptionManager = new SubscriptionManagerNode();
    private final transient MutableEventProcessorContext context = new MutableEventProcessorContext(this.nodeNameLookup, this.callbackDispatcher, this.subscriptionManager, this.callbackDispatcher);
    public final transient ServiceRegistryNode serviceRegistry = new ServiceRegistryNode();
    private final transient ObjectEventHandlerNode allEventHandler;
    private final transient ExportFunctionAuditEvent functionAudit = new ExportFunctionAuditEvent();
    private boolean initCalled = false;
    private boolean processing = false;
    private boolean buffering = false;
    private final transient IdentityHashMap<Object, BooleanSupplier> dirtyFlagSupplierMap = new IdentityHashMap(1);
    private final transient IdentityHashMap<Object, Consumer<Boolean>> dirtyFlagUpdateMap = new IdentityHashMap(1);
    private boolean isDirty_clock = false;
    private Consumer unKnownEventHandler = e -> {};

    public DefaultEventProcessor(ObjectEventHandlerNode allEventHandler, Map<Object, Object> contextMap) {
        this.allEventHandler = allEventHandler;
        if (this.context != null) {
            this.context.replaceMappings(contextMap);
        }
        this.context.setClock(this.clock);
        this.serviceRegistry.setEventProcessorContext(this.context);
        this.initialiseAuditor(this.clock);
        this.initialiseAuditor(this.nodeNameLookup);
        this.initialiseAuditor(this.serviceRegistry);
        if (this.subscriptionManager != null) {
            this.subscriptionManager.setSubscribingEventProcessor(this);
        }
        if (this.context != null) {
            this.context.setEventProcessorCallback(this);
        }
    }

    public DefaultEventProcessor(ObjectEventHandlerNode allEventHandler) {
        this(allEventHandler, null);
    }

    @Override
    public void init() {
        this.initCalled = true;
        this.auditEvent((Object)Lifecycle.LifecycleEvent.Init);
        this.isDirty("test");
        this.clock.init();
        this.allEventHandler.init();
        this.afterEvent();
    }

    @Override
    public void start() {
        if (!this.initCalled) {
            throw new RuntimeException("init() must be called before start()");
        }
        this.processing = true;
        this.auditEvent((Object)Lifecycle.LifecycleEvent.Start);
        this.allEventHandler.start();
        this.afterEvent();
        this.callbackDispatcher.dispatchQueuedCallbacks();
        this.processing = false;
    }

    @Override
    public void startComplete() {
        if (!this.initCalled) {
            throw new RuntimeException("init() must be called before startComplete()");
        }
        this.processing = true;
        this.auditEvent((Object)Lifecycle.LifecycleEvent.StartComplete);
        this.afterEvent();
        this.callbackDispatcher.dispatchQueuedCallbacks();
        this.processing = false;
    }

    @Override
    public void stop() {
        if (!this.initCalled) {
            throw new RuntimeException("init() must be called before stop()");
        }
        this.processing = true;
        this.auditEvent((Object)Lifecycle.LifecycleEvent.Stop);
        this.allEventHandler.stop();
        this.afterEvent();
        this.callbackDispatcher.dispatchQueuedCallbacks();
        this.processing = false;
    }

    @Override
    public void tearDown() {
        this.initCalled = false;
        this.auditEvent((Object)Lifecycle.LifecycleEvent.TearDown);
        this.serviceRegistry.tearDown();
        this.nodeNameLookup.tearDown();
        this.clock.tearDown();
        this.allEventHandler.tearDown();
        this.subscriptionManager.tearDown();
        this.afterEvent();
    }

    @Override
    public void setContextParameterMap(Map<Object, Object> newContextMapping) {
        this.context.replaceMappings(newContextMapping);
    }

    @Override
    public void addContextParameter(Object key, Object value) {
        this.context.addMapping(key, value);
    }

    @Override
    @OnEventHandler(failBuildIfMissingBooleanReturn=false)
    public void onEvent(Object event) {
        if (this.buffering) {
            this.triggerCalculation();
        }
        if (this.processing) {
            this.callbackDispatcher.queueReentrantEvent(event);
        } else {
            this.processing = true;
            this.onEventInternal(event);
            this.callbackDispatcher.dispatchQueuedCallbacks();
            this.processing = false;
        }
    }

    @Override
    public void onEventInternal(Object event) {
        if (event instanceof ClockStrategy.ClockStrategyEvent) {
            ClockStrategy.ClockStrategyEvent typedEvent = (ClockStrategy.ClockStrategyEvent)event;
            this.handleEvent(typedEvent);
        } else if (event instanceof Object) {
            Object typedEvent = event;
            this.handleEvent(typedEvent);
        }
    }

    public void handleEvent(ClockStrategy.ClockStrategyEvent typedEvent) {
        this.auditEvent(typedEvent);
        this.isDirty_clock = true;
        this.clock.setClockStrategy(typedEvent);
        this.allEventHandler.onEvent(typedEvent);
        this.afterEvent();
    }

    public void handleEvent(Object typedEvent) {
        this.auditEvent(typedEvent);
        this.allEventHandler.onEvent(typedEvent);
        this.afterEvent();
    }

    @Override
    public void deRegisterService(Service<?> arg0) {
        this.beforeServiceCall("public void com.fluxtion.runtime.service.ServiceRegistryNode.deRegisterService(com.fluxtion.runtime.service.Service<?>)");
        ExportFunctionAuditEvent typedEvent = this.functionAudit;
        this.serviceRegistry.deRegisterService(arg0);
        this.afterServiceCall();
    }

    @Override
    public void registerService(Service<?> arg0) {
        this.beforeServiceCall("public void com.fluxtion.runtime.service.ServiceRegistryNode.registerService(com.fluxtion.runtime.service.Service<?>)");
        ExportFunctionAuditEvent typedEvent = this.functionAudit;
        this.serviceRegistry.registerService(arg0);
        this.afterServiceCall();
    }

    @Override
    public void bufferEvent(Object event) {
        this.buffering = true;
        if (event instanceof ClockStrategy.ClockStrategyEvent) {
            ClockStrategy.ClockStrategyEvent typedEvent = (ClockStrategy.ClockStrategyEvent)event;
            this.auditEvent(typedEvent);
            this.isDirty_clock = true;
            this.clock.setClockStrategy(typedEvent);
            this.allEventHandler.onEvent(typedEvent);
        } else if (event instanceof Object) {
            Object typedEvent = event;
            this.auditEvent(typedEvent);
            this.allEventHandler.onEvent(typedEvent);
        }
    }

    @Override
    public void triggerCalculation() {
        this.buffering = false;
        String typedEvent = "No event information - buffered dispatch";
        this.afterEvent();
    }

    private void auditEvent(Object typedEvent) {
        this.clock.eventReceived(typedEvent);
        this.nodeNameLookup.eventReceived(typedEvent);
        this.serviceRegistry.eventReceived(typedEvent);
    }

    private void auditEvent(Event typedEvent) {
        this.clock.eventReceived(typedEvent);
        this.nodeNameLookup.eventReceived(typedEvent);
        this.serviceRegistry.eventReceived(typedEvent);
    }

    private void initialiseAuditor(Auditor auditor) {
        auditor.init();
        auditor.nodeRegistered(this.allEventHandler, "allEventHandler");
        auditor.nodeRegistered(this.callbackDispatcher, "callbackDispatcher");
        auditor.nodeRegistered(this.subscriptionManager, "subscriptionManager");
        auditor.nodeRegistered(this.context, "context");
    }

    private void beforeServiceCall(String functionDescription) {
        this.functionAudit.setFunctionDescription(functionDescription);
        this.auditEvent(this.functionAudit);
        if (this.buffering) {
            this.triggerCalculation();
        }
        this.processing = true;
    }

    private void afterServiceCall() {
        this.afterEvent();
        this.callbackDispatcher.dispatchQueuedCallbacks();
        this.processing = false;
    }

    private void afterEvent() {
        this.clock.processingComplete();
        this.nodeNameLookup.processingComplete();
        this.serviceRegistry.processingComplete();
        this.isDirty_clock = false;
    }

    @Override
    public void batchPause() {
        this.auditEvent((Object)Lifecycle.LifecycleEvent.BatchPause);
        this.processing = true;
        this.afterEvent();
        this.callbackDispatcher.dispatchQueuedCallbacks();
        this.processing = false;
    }

    @Override
    public void batchEnd() {
        this.auditEvent((Object)Lifecycle.LifecycleEvent.BatchEnd);
        this.processing = true;
        this.afterEvent();
        this.callbackDispatcher.dispatchQueuedCallbacks();
        this.processing = false;
    }

    @Override
    public boolean isDirty(Object node) {
        return this.dirtySupplier(node).getAsBoolean();
    }

    @Override
    public BooleanSupplier dirtySupplier(Object node) {
        if (this.dirtyFlagSupplierMap.isEmpty()) {
            this.dirtyFlagSupplierMap.put(this.clock, () -> this.isDirty_clock);
        }
        return this.dirtyFlagSupplierMap.getOrDefault(node, StaticEventProcessor.ALWAYS_FALSE);
    }

    @Override
    public void setDirty(Object node, boolean dirtyFlag) {
        if (this.dirtyFlagUpdateMap.isEmpty()) {
            this.dirtyFlagUpdateMap.put(this.clock, b -> {
                this.isDirty_clock = b;
            });
        }
        this.dirtyFlagUpdateMap.get(node).accept(dirtyFlag);
    }

    private boolean guardCheck_context() {
        return this.isDirty_clock;
    }

    @Override
    public <T> T getNodeById(String id) throws NoSuchFieldException {
        return this.nodeNameLookup.getInstanceById(id);
    }

    @Override
    public <A extends Auditor> A getAuditorById(String id) throws NoSuchFieldException, IllegalAccessException {
        return (A)((Auditor)this.getClass().getField(id).get(this));
    }

    @Override
    public void addEventFeed(EventFeed eventProcessorFeed) {
        this.subscriptionManager.addEventProcessorFeed(eventProcessorFeed);
    }

    @Override
    public void removeEventFeed(EventFeed eventProcessorFeed) {
        this.subscriptionManager.removeEventProcessorFeed(eventProcessorFeed);
    }

    @Override
    public DefaultEventProcessor newInstance() {
        return new DefaultEventProcessor(this.allEventHandler);
    }

    @Override
    public DefaultEventProcessor newInstance(Map<Object, Object> contextMap) {
        return new DefaultEventProcessor(this.allEventHandler);
    }

    @Override
    public String getLastAuditLogRecord() {
        try {
            EventLogManager eventLogManager = (EventLogManager)this.getClass().getField("eventLogger").get(this);
            return eventLogManager.lastRecordAsString();
        }
        catch (Throwable e) {
            return "";
        }
    }

    public void unKnownEventHandler(Object object) {
        this.unKnownEventHandler.accept(object);
    }

    @Override
    public <T> void setUnKnownEventHandler(Consumer<T> consumer) {
        this.unKnownEventHandler = consumer;
    }

    @Override
    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }
}

