/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime;

import com.fluxtion.runtime.StaticEventProcessor;
import com.fluxtion.runtime.callback.DirtyStateMonitor;
import com.fluxtion.runtime.callback.EventDispatcher;
import com.fluxtion.runtime.input.SubscriptionManager;
import com.fluxtion.runtime.node.NodeNameLookup;
import com.fluxtion.runtime.time.Clock;

public interface EventProcessorContext {
    public static final String DEFAULT_NODE_NAME = "context";

    public NodeNameLookup getNodeNameLookup();

    public EventDispatcher getEventDispatcher();

    public DirtyStateMonitor getDirtyStateMonitor();

    public SubscriptionManager getSubscriptionManager();

    public Clock getClock();

    public <T> T getExportedService(Class<T> var1);

    public <T> T getExportedService();

    public <T> T getInjectedInstance(Class<T> var1);

    public <T> T getInjectedInstance(Class<T> var1, String var2);

    public <T> T getInjectedInstanceAllowNull(Class<T> var1);

    public <T> T getInjectedInstanceAllowNull(Class<T> var1, String var2);

    public <K, V> V getContextProperty(K var1);

    default public StaticEventProcessor getStaticEventProcessor() {
        return this.getExportedService(StaticEventProcessor.class);
    }

    default public void processReentrantEvent(Object event) {
        this.getEventDispatcher().processReentrantEvent(event);
    }

    default public void processAsNewEventCycle(Object event) {
        this.getEventDispatcher().processAsNewEventCycle(event);
    }

    default public void processAsNewEventCycle(Iterable<Object> iterable) {
        this.getEventDispatcher().processAsNewEventCycle(iterable);
    }

    default public void isDirty(Object node) {
        this.getDirtyStateMonitor().isDirty(node);
    }

    default public void markDirty(Object node) {
        this.getDirtyStateMonitor().markDirty(node);
    }

    default public String lookupInstanceName(Object node) {
        return this.getNodeNameLookup().lookupInstanceName(node);
    }

    default public <V> V getInstanceById(String instanceId) throws NoSuchFieldException {
        return (V)this.getNodeNameLookup().getInstanceById(instanceId);
    }

    default public void subscribeToNamedFeed(String feedName) {
        this.getSubscriptionManager().subscribeToNamedFeed(feedName);
    }

    default public void unSubscribeToNamedFeed(String feedName) {
        this.getSubscriptionManager().unSubscribeToNamedFeed(feedName);
    }
}

