/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime;

import com.fluxtion.runtime.NodeDiscovery;
import com.fluxtion.runtime.annotations.builder.FluxtionIgnore;
import com.fluxtion.runtime.audit.Auditor;
import com.fluxtion.runtime.audit.EventLogControlEvent;
import com.fluxtion.runtime.audit.EventLogManager;
import com.fluxtion.runtime.audit.LogRecord;
import com.fluxtion.runtime.audit.LogRecordListener;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.event.Signal;
import com.fluxtion.runtime.input.EventFeed;
import com.fluxtion.runtime.input.SubscriptionManager;
import com.fluxtion.runtime.output.SinkDeregister;
import com.fluxtion.runtime.output.SinkRegistration;
import com.fluxtion.runtime.service.Service;
import com.fluxtion.runtime.service.ServiceRegistry;
import com.fluxtion.runtime.time.ClockStrategy;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.function.ObjLongConsumer;

public interface StaticEventProcessor
extends ServiceRegistry,
NodeDiscovery {
    @FluxtionIgnore
    public static final StaticEventProcessor NULL_EVENTHANDLER = e -> {};
    public static final BooleanSupplier ALWAYS_FALSE = () -> false;

    default public void setContextParameterMap(Map<Object, Object> newContextMapping) {
        throw new UnsupportedOperationException("this StaticEventProcessor does not accept updated context map");
    }

    default public <T> void injectInstance(T instance) {
        this.injectInstance(instance, instance.getClass());
    }

    default public void injectNamedInstance(Object instance, String name) {
        this.addContextParameter(instance.getClass().getCanonicalName() + "_" + name, instance);
    }

    default public <T, S extends T> void injectInstance(S instance, Class<T> exposedType) {
        this.addContextParameter(exposedType.getCanonicalName(), instance);
    }

    default public <T, S extends T> void injectNamedInstance(S instance, Class<T> exposedType, String name) {
        this.addContextParameter(exposedType.getCanonicalName() + "_" + name, instance);
    }

    default public void addContextParameter(Object key, Object value) {
        throw new UnsupportedOperationException("this StaticEventProcessor does not accept updates to context map");
    }

    public void onEvent(Object var1);

    default public void onEvent(byte value) {
        this.onEvent((Object)value);
    }

    default public void onEvent(char value) {
        this.onEvent(Character.valueOf(value));
    }

    default public void onEvent(short value) {
        this.onEvent((Object)value);
    }

    default public void onEvent(int value) {
        this.onEvent((Object)value);
    }

    default public void onEvent(float value) {
        this.onEvent(Float.valueOf(value));
    }

    default public void onEvent(double value) {
        this.onEvent((Object)value);
    }

    default public void onEvent(long value) {
        this.onEvent((Object)value);
    }

    default public void bufferEvent(Object event) {
        throw new UnsupportedOperationException("buffering of events not supported");
    }

    default public void bufferEvent(byte value) {
        this.bufferEvent((Object)value);
    }

    default public void bufferEvent(char value) {
        this.bufferEvent(Character.valueOf(value));
    }

    default public void bufferEvent(short value) {
        this.bufferEvent((Object)value);
    }

    default public void bufferEvent(int value) {
        this.bufferEvent((Object)value);
    }

    default public void bufferEvent(float value) {
        this.bufferEvent(Float.valueOf(value));
    }

    default public void bufferEvent(double value) {
        this.bufferEvent((Object)value);
    }

    default public void bufferEvent(long value) {
        this.bufferEvent((Object)value);
    }

    default public void triggerCalculation() {
        throw new UnsupportedOperationException("buffering of events not supported");
    }

    default public <T> void addSink(String id, Consumer<T> sink) {
        this.onEvent(SinkRegistration.sink(id, sink));
    }

    default public void addIntSink(String id, IntConsumer sink) {
        this.onEvent(SinkRegistration.intSink(id, sink));
    }

    default public void addDoubleSink(String id, DoubleConsumer sink) {
        this.onEvent(SinkRegistration.doubleSink(id, sink));
    }

    default public void addLongSink(String id, LongConsumer sink) {
        this.onEvent(SinkRegistration.longSink(id, sink));
    }

    default public void removeSink(String id) {
        this.onEvent(SinkDeregister.sink(id));
    }

    default public <T> void publishObjectSignal(T instance) {
        this.onEvent(new Signal<T>(instance));
    }

    default public <S, T> void publishObjectSignal(Class<S> filterClass, T instance) {
        this.onEvent(new Signal<T>(filterClass, instance));
    }

    default public void publishSignal(String filter) {
        this.publishSignal(filter, new Object());
    }

    default public <T> void publishSignal(String filter, T value) {
        this.onEvent(new Signal<T>(filter, value));
    }

    default public void publishSignal(String filter, int value) {
        this.onEvent(Signal.intSignal(filter, value));
    }

    default public void publishIntSignal(String filter, int value) {
        this.publishSignal(filter, value);
    }

    default public void publishSignal(String filter, double value) {
        this.onEvent(Signal.doubleSignal(filter, value));
    }

    default public void publishDoubleSignal(String filter, double value) {
        this.publishSignal(filter, value);
    }

    default public void publishSignal(String filter, long value) {
        this.onEvent(Signal.longSignal(filter, value));
    }

    default public void publishLongSignal(String filter, long value) {
        this.publishSignal(filter, value);
    }

    @Override
    default public <T> T getNodeById(String id) throws NoSuchFieldException {
        throw new NoSuchFieldException(id);
    }

    default public <T> T getStreamed(String name) throws NoSuchFieldException {
        FlowFunction stream = (FlowFunction)this.getNodeById(name);
        return stream.get();
    }

    default public <A extends Auditor> A getAuditorById(String id) throws NoSuchFieldException, IllegalAccessException {
        return (A)((Auditor)this.getNodeById(id));
    }

    default public void addEventFeed(EventFeed eventProcessorFeed) {
        throw new UnsupportedOperationException("addEventProcessorFeed not implemented");
    }

    default public void removeEventFeed(EventFeed eventProcessorFeed) {
        throw new UnsupportedOperationException("removeEventProcessorFeed not implemented");
    }

    default public void setAuditLogLevel(EventLogControlEvent.LogLevel logLevel) {
        this.onEvent(new EventLogControlEvent(logLevel));
    }

    default public void setAuditLogLevel(EventLogControlEvent.LogLevel logLevel, String nodeName) {
        this.onEvent(new EventLogControlEvent(nodeName, null, logLevel));
    }

    default public void setAuditLogProcessor(LogRecordListener logProcessor) {
        this.onEvent(new EventLogControlEvent(logProcessor));
    }

    default public void setAuditLogRecordEncoder(LogRecord logRecord) {
        this.onEvent(new EventLogControlEvent(logRecord));
    }

    default public void setAuditTimeFormatter(ObjLongConsumer<StringBuilder> timeFormatter) {
        this.onEvent(new EventLogControlEvent(timeFormatter));
    }

    default public String getLastAuditLogRecord() {
        try {
            return ((EventLogManager)this.getNodeById("eventLogger")).lastRecordAsString();
        }
        catch (Throwable e) {
            return "";
        }
    }

    default public void setClockStrategy(ClockStrategy clockStrategy) {
        this.onEvent(ClockStrategy.registerClockEvent(clockStrategy));
    }

    default public <T> T getExportedService() {
        return (T)this;
    }

    default public <T> boolean exportsService(Class<T> exportedServiceClass) {
        T svcExport = this.getExportedService();
        return exportedServiceClass.isInstance(svcExport);
    }

    default public <T> T getExportedService(Class<T> exportedServiceClass) {
        return this.exportsService(exportedServiceClass) ? (T)this.getExportedService() : null;
    }

    default public <T> T getExportedService(Class<T> exportedServiceClass, T defaultValue) {
        return this.exportsService(exportedServiceClass) ? this.getExportedService() : defaultValue;
    }

    default public <T> void consumeServiceIfExported(Class<T> exportedServiceClass, Consumer<T> serviceConsumer) {
        T exportedService = this.getExportedService(exportedServiceClass);
        if (exportedService != null) {
            serviceConsumer.accept(exportedService);
        }
    }

    default public <T> void setUnKnownEventHandler(Consumer<T> consumer) {
    }

    @Override
    default public void registerService(Service<?> service) {
    }

    @Override
    default public void deRegisterService(Service<?> service) {
    }

    default public SubscriptionManager getSubscriptionManager() {
        throw new UnsupportedOperationException();
    }
}

