/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.audit;

import com.fluxtion.runtime.audit.LogRecord;
import com.fluxtion.runtime.audit.LogRecordListener;
import com.fluxtion.runtime.event.Event;
import java.util.function.ObjLongConsumer;

public class EventLogControlEvent
implements Event {
    private LogLevel level;
    private String sourceId;
    private String groupId;
    private LogRecordListener logRecordProcessor;
    private LogRecord logRecord;
    private ObjLongConsumer<StringBuilder> timeFormatter;

    public EventLogControlEvent() {
        this(LogLevel.INFO);
    }

    public EventLogControlEvent(LogLevel level) {
        this(null, null, level);
    }

    public EventLogControlEvent(LogRecordListener logRecordProcessor) {
        this(null, null, null);
        this.logRecordProcessor = logRecordProcessor;
    }

    public EventLogControlEvent(LogRecord logRecord) {
        this(null, null, null);
        this.logRecord = logRecord;
    }

    public EventLogControlEvent(ObjLongConsumer<StringBuilder> timeFormatter) {
        this(null, null, null);
        this.timeFormatter = timeFormatter;
    }

    public EventLogControlEvent(String sourceId, String groupId, LogLevel level) {
        this.sourceId = sourceId;
        this.groupId = groupId;
        this.level = level;
    }

    public EventLogControlEvent(String sourceId, String groupId, LogLevel level, LogRecordListener logRecordProcessor) {
        this.sourceId = sourceId;
        this.groupId = groupId;
        this.logRecordProcessor = logRecordProcessor;
        this.level = level;
    }

    public String toString() {
        return "EventLogConfig{level=" + (Object)((Object)this.level) + ", logRecordProcessor=" + this.logRecordProcessor + ", sourceId=" + this.sourceId + ", groupId=" + this.groupId + '}';
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public LogRecordListener getLogRecordProcessor() {
        return this.logRecordProcessor;
    }

    public LogRecord getLogRecord() {
        return this.logRecord;
    }

    public ObjLongConsumer<StringBuilder> getTimeFormatter() {
        return this.timeFormatter;
    }

    public static enum LogLevel {
        NONE(0),
        ERROR(1),
        WARN(2),
        INFO(3),
        DEBUG(4),
        TRACE(5);

        public final int level;

        private LogLevel(int level) {
            this.level = level;
        }
    }
}

