/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.audit;

import com.fluxtion.runtime.audit.EventLogControlEvent;
import com.fluxtion.runtime.audit.LogRecord;

public class EventLogger {
    private final LogRecord logrecord;
    private final String logSourceId;
    private EventLogControlEvent.LogLevel logLevel;

    public EventLogger(LogRecord logrecord, String logSourceId) {
        this.logrecord = logrecord;
        this.logSourceId = logSourceId;
        this.logLevel = EventLogControlEvent.LogLevel.INFO;
    }

    public EventLogger setLevel(EventLogControlEvent.LogLevel level) {
        this.logLevel = level;
        this.logrecord.updateLogLevel(level);
        return this;
    }

    public EventLogger error() {
        this.logNodeInvocation(EventLogControlEvent.LogLevel.ERROR);
        return this;
    }

    public EventLogger warn() {
        this.logNodeInvocation(EventLogControlEvent.LogLevel.WARN);
        return this;
    }

    public EventLogger info() {
        this.logNodeInvocation(EventLogControlEvent.LogLevel.INFO);
        return this;
    }

    public EventLogger debug() {
        this.logNodeInvocation(EventLogControlEvent.LogLevel.DEBUG);
        return this;
    }

    public EventLogger trace() {
        this.logNodeInvocation(EventLogControlEvent.LogLevel.TRACE);
        return this;
    }

    public EventLogger error(String key, String value) {
        this.log(key, value, EventLogControlEvent.LogLevel.ERROR);
        return this;
    }

    public EventLogger warn(String key, String value) {
        this.log(key, value, EventLogControlEvent.LogLevel.WARN);
        return this;
    }

    public EventLogger info(String key, String value) {
        this.log(key, value, EventLogControlEvent.LogLevel.INFO);
        return this;
    }

    public EventLogger debug(String key, String value) {
        this.log(key, value, EventLogControlEvent.LogLevel.DEBUG);
        return this;
    }

    public EventLogger trace(String key, String value) {
        this.log(key, value, EventLogControlEvent.LogLevel.TRACE);
        return this;
    }

    public EventLogger error(String key, boolean value) {
        this.log(key, value, EventLogControlEvent.LogLevel.ERROR);
        return this;
    }

    public EventLogger warn(String key, boolean value) {
        this.log(key, value, EventLogControlEvent.LogLevel.WARN);
        return this;
    }

    public EventLogger error(String key, Object value) {
        this.log(key, value, EventLogControlEvent.LogLevel.ERROR);
        return this;
    }

    public EventLogger warn(String key, Object value) {
        this.log(key, value, EventLogControlEvent.LogLevel.WARN);
        return this;
    }

    public EventLogger info(String key, Object value) {
        this.log(key, value, EventLogControlEvent.LogLevel.INFO);
        return this;
    }

    public EventLogger debug(String key, Object value) {
        this.log(key, value, EventLogControlEvent.LogLevel.DEBUG);
        return this;
    }

    public EventLogger trace(String key, Object value) {
        this.log(key, value, EventLogControlEvent.LogLevel.TRACE);
        return this;
    }

    public EventLogger info(String key, boolean value) {
        this.log(key, value, EventLogControlEvent.LogLevel.INFO);
        return this;
    }

    public EventLogger debug(String key, boolean value) {
        this.log(key, value, EventLogControlEvent.LogLevel.DEBUG);
        return this;
    }

    public EventLogger trace(String key, boolean value) {
        this.log(key, value, EventLogControlEvent.LogLevel.TRACE);
        return this;
    }

    public EventLogger error(String key, double value) {
        this.log(key, value, EventLogControlEvent.LogLevel.ERROR);
        return this;
    }

    public EventLogger warn(String key, double value) {
        this.log(key, value, EventLogControlEvent.LogLevel.WARN);
        return this;
    }

    public EventLogger info(String key, double value) {
        this.log(key, value, EventLogControlEvent.LogLevel.INFO);
        return this;
    }

    public EventLogger debug(String key, double value) {
        this.log(key, value, EventLogControlEvent.LogLevel.DEBUG);
        return this;
    }

    public EventLogger trace(String key, double value) {
        this.log(key, value, EventLogControlEvent.LogLevel.TRACE);
        return this;
    }

    public EventLogger error(String key, int value) {
        this.log(key, value, EventLogControlEvent.LogLevel.ERROR);
        return this;
    }

    public EventLogger warn(String key, int value) {
        this.log(key, value, EventLogControlEvent.LogLevel.WARN);
        return this;
    }

    public EventLogger info(String key, int value) {
        this.log(key, value, EventLogControlEvent.LogLevel.INFO);
        return this;
    }

    public EventLogger debug(String key, long value) {
        this.log(key, value, EventLogControlEvent.LogLevel.DEBUG);
        return this;
    }

    public EventLogger trace(String key, long value) {
        this.log(key, value, EventLogControlEvent.LogLevel.TRACE);
        return this;
    }

    public EventLogger error(String key, long value) {
        this.log(key, value, EventLogControlEvent.LogLevel.ERROR);
        return this;
    }

    public EventLogger warn(String key, long value) {
        this.log(key, value, EventLogControlEvent.LogLevel.WARN);
        return this;
    }

    public EventLogger info(String key, long value) {
        this.log(key, value, EventLogControlEvent.LogLevel.INFO);
        return this;
    }

    public EventLogger debug(String key, int value) {
        this.log(key, value, EventLogControlEvent.LogLevel.DEBUG);
        return this;
    }

    public EventLogger trace(String key, int value) {
        this.log(key, value, EventLogControlEvent.LogLevel.TRACE);
        return this;
    }

    public EventLogger error(String key, char value) {
        this.log(key, value, EventLogControlEvent.LogLevel.ERROR);
        return this;
    }

    public EventLogger warn(String key, char value) {
        this.log(key, value, EventLogControlEvent.LogLevel.WARN);
        return this;
    }

    public EventLogger info(String key, char value) {
        this.log(key, value, EventLogControlEvent.LogLevel.INFO);
        return this;
    }

    public EventLogger debug(String key, char value) {
        this.log(key, value, EventLogControlEvent.LogLevel.DEBUG);
        return this;
    }

    public EventLogger trace(String key, char value) {
        this.log(key, value, EventLogControlEvent.LogLevel.TRACE);
        return this;
    }

    public EventLogger logNodeInvocation(EventLogControlEvent.LogLevel logLevel) {
        if (this.logLevel.level >= logLevel.level) {
            this.logrecord.addTrace(this.logSourceId);
        }
        return this;
    }

    public EventLogger log(String key, Object value, EventLogControlEvent.LogLevel logLevel) {
        if (this.logLevel.level >= logLevel.level) {
            this.logrecord.addRecord(this.logSourceId, key, value);
        }
        return this;
    }

    public EventLogger log(String key, double value, EventLogControlEvent.LogLevel logLevel) {
        if (this.logLevel.level >= logLevel.level) {
            this.logrecord.addRecord(this.logSourceId, key, value);
        }
        return this;
    }

    public EventLogger log(String key, int value, EventLogControlEvent.LogLevel logLevel) {
        if (this.logLevel.level >= logLevel.level) {
            this.logrecord.addRecord(this.logSourceId, key, value);
        }
        return this;
    }

    public EventLogger log(String key, long value, EventLogControlEvent.LogLevel logLevel) {
        if (this.logLevel.level >= logLevel.level) {
            this.logrecord.addRecord(this.logSourceId, key, value);
        }
        return this;
    }

    public EventLogger log(String key, char value, EventLogControlEvent.LogLevel logLevel) {
        if (this.logLevel.level >= logLevel.level) {
            this.logrecord.addRecord(this.logSourceId, key, value);
        }
        return this;
    }

    public EventLogger log(String key, CharSequence value, EventLogControlEvent.LogLevel logLevel) {
        if (this.logLevel.level >= logLevel.level) {
            this.logrecord.addRecord(this.logSourceId, key, value);
        }
        return this;
    }

    public EventLogger log(String key, boolean value, EventLogControlEvent.LogLevel logLevel) {
        if (this.logLevel.level >= logLevel.level) {
            this.logrecord.addRecord(this.logSourceId, key, value);
        }
        return this;
    }

    public boolean canLog(EventLogControlEvent.LogLevel logLevel) {
        return this.logLevel != null && this.logLevel.level >= logLevel.level;
    }
}

