/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.audit;

import com.fluxtion.runtime.audit.LogRecord;
import com.fluxtion.runtime.audit.LogRecordListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JULLogRecordListener
implements LogRecordListener {
    private static Logger logger = Logger.getLogger("fluxtion.eventLog");
    private static Level level = Level.INFO;

    public JULLogRecordListener() {
        logger.setUseParentHandlers(false);
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        ConsoleHandler console = new ConsoleHandler();
        console.setFormatter(new FormatterImpl());
        logger.addHandler(console);
    }

    public JULLogRecordListener(File file) throws IOException {
        logger.setUseParentHandlers(false);
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        FileHandler fileHandler = new FileHandler(file.getCanonicalPath());
        fileHandler.setFormatter(new FormatterImpl());
        logger.addHandler(fileHandler);
    }

    @Override
    public void processLogRecord(LogRecord logRecord) {
        logger.log(level, logRecord.toString() + "\n---\n");
    }

    private static class FormatterImpl
    extends Formatter {
        private FormatterImpl() {
        }

        @Override
        public String format(java.util.logging.LogRecord record) {
            return record.getMessage();
        }
    }
}

