/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.audit;

import com.fluxtion.runtime.audit.EventLogControlEvent;
import com.fluxtion.runtime.event.Event;
import com.fluxtion.runtime.time.Clock;
import java.util.function.ObjLongConsumer;

public class LogRecord {
    public String groupingId;
    private EventLogControlEvent.LogLevel logLevel;
    protected final StringBuilder sb;
    protected String sourceId;
    protected boolean firstProp = true;
    protected Clock clock;
    protected boolean printEventToString = false;
    protected boolean printThreadName = false;
    protected ObjLongConsumer<StringBuilder> timeFormatter = StringBuilder::append;

    public LogRecord(Clock clock) {
        this(clock, EventLogControlEvent.LogLevel.INFO);
    }

    public LogRecord(Clock clock, EventLogControlEvent.LogLevel logLevel) {
        this.sb = new StringBuilder();
        this.clock = clock;
        this.updateLogLevel(logLevel);
    }

    public void updateLogLevel(EventLogControlEvent.LogLevel newLogLevel) {
        EventLogControlEvent.LogLevel logLevel = this.logLevel = newLogLevel == null ? EventLogControlEvent.LogLevel.NONE : newLogLevel;
        if (!this.loggingEnabled()) {
            this.sb.setLength(0);
        }
    }

    public void replaceBuffer(CharSequence newBuffer) {
        this.sb.setLength(0);
        this.sb.append(newBuffer);
    }

    public void addRecord(String sourceId, String propertyKey, double value) {
        this.addSourceId(sourceId, propertyKey);
        this.sb.append(value);
    }

    public void addRecord(String sourceId, String propertyKey, long value) {
        this.addSourceId(sourceId, propertyKey);
        this.sb.append(value);
    }

    public void addRecord(String sourceId, String propertyKey, int value) {
        this.addSourceId(sourceId, propertyKey);
        this.sb.append(value);
    }

    public void addRecord(String sourceId, String propertyKey, char value) {
        this.addSourceId(sourceId, propertyKey);
        this.sb.append(value);
    }

    public void addRecord(String sourceId, String propertyKey, CharSequence value) {
        this.addSourceId(sourceId, propertyKey);
        this.sb.append(value);
    }

    public void addRecord(String sourceId, String propertyKey, Object value) {
        this.addSourceId(sourceId, propertyKey);
        this.sb.append(value == null ? "NULL" : value);
    }

    public void addRecord(String sourceId, String propertyKey, boolean value) {
        this.addSourceId(sourceId, propertyKey);
        this.sb.append(value);
    }

    public void addTrace(String sourceId) {
        if (this.sourceId != null) {
            this.sb.append("}");
        }
        this.firstProp = true;
        this.sourceId = null;
        this.addSourceId(sourceId, null);
    }

    public void printEventToString(boolean printEventToString) {
        this.printEventToString = printEventToString;
    }

    protected void addSourceId(String sourceId, String propertyKey) {
        if (this.loggingEnabled()) {
            if (this.sourceId == null) {
                this.sb.append("\n        - ").append(sourceId).append(": {");
                this.sourceId = sourceId;
            } else if (!this.sourceId.equals(sourceId)) {
                this.sb.append("}\n        - ").append(sourceId).append(": {");
                this.sourceId = sourceId;
                this.firstProp = true;
            }
            if (!this.firstProp) {
                this.sb.append(",");
            }
            if (propertyKey != null) {
                this.firstProp = false;
                this.sb.append(" ").append(propertyKey).append(": ");
            }
        }
    }

    public void clear() {
        this.firstProp = true;
        this.sourceId = null;
        this.sb.setLength(0);
    }

    public CharSequence asCharSequence() {
        return this.sb;
    }

    public void triggerEvent(Event event) {
        if (this.loggingEnabled()) {
            Class<?> aClass = event.getClass();
            this.sb.append("eventLogRecord: ");
            this.sb.append("\n    eventTime: ");
            this.timeFormatter.accept(this.sb, this.clock.getEventTime());
            this.sb.append("\n    logTime: ");
            this.timeFormatter.accept(this.sb, this.clock.getWallClockTime());
            this.sb.append("\n    groupingId: ").append(this.groupingId);
            this.sb.append("\n    event: ").append(aClass.getSimpleName());
            if (this.printEventToString) {
                this.sb.append("\n    eventToString: ").append(event.toString());
            }
            if (this.printThreadName) {
                this.sb.append("\n    thread: ").append(Thread.currentThread().getName());
            }
            if (event.filterString() != null && !event.filterString().isEmpty()) {
                this.sb.append("\n    eventFilter: ").append(event.filterString());
            }
            this.sb.append("\n    nodeLogs: ");
        }
    }

    public void triggerObject(Object event) {
        if (this.loggingEnabled()) {
            if (event instanceof Event) {
                this.triggerEvent((Event)event);
            } else {
                Class<?> aClass = event.getClass();
                this.sb.append("eventLogRecord: ");
                this.sb.append("\n    eventTime: ");
                this.timeFormatter.accept(this.sb, this.clock.getEventTime());
                this.sb.append("\n    logTime: ");
                this.timeFormatter.accept(this.sb, this.clock.getWallClockTime());
                this.sb.append("\n    groupingId: ").append(this.groupingId);
                this.sb.append("\n    event: ").append(aClass.getSimpleName());
                if (this.printEventToString) {
                    this.sb.append("\n    eventToString: ").append(event.toString());
                }
                this.sb.append("\n    nodeLogs: ");
            }
        }
    }

    public boolean terminateRecord() {
        boolean logged;
        boolean bl = logged = !this.firstProp;
        if (this.loggingEnabled()) {
            if (this.sourceId != null) {
                this.sb.append("}");
            }
            this.sb.append("\n    endTime: ");
            this.timeFormatter.accept(this.sb, this.clock.getWallClockTime());
        }
        this.firstProp = true;
        this.sourceId = null;
        return logged;
    }

    public String toString() {
        return this.asCharSequence().toString();
    }

    protected boolean loggingEnabled() {
        return this.logLevel != EventLogControlEvent.LogLevel.NONE;
    }

    public EventLogControlEvent.LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public void setPrintThreadName(boolean printThreadName) {
        this.printThreadName = printThreadName;
    }

    public void setTimeFormatter(ObjLongConsumer<StringBuilder> timeFormatter) {
        this.timeFormatter = timeFormatter;
    }
}

