/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.audit;

import com.fluxtion.runtime.audit.Auditor;
import com.fluxtion.runtime.node.NamedNode;
import com.fluxtion.runtime.node.NodeNameLookup;
import java.util.HashMap;
import java.util.Map;

public class NodeNameAuditor
implements Auditor,
NodeNameLookup,
NamedNode {
    private final transient Map<Object, String> node2NameMap = new HashMap<Object, String>();
    private final transient Map<String, Object> name2NodeMap = new HashMap<String, Object>();

    @Override
    public void nodeRegistered(Object node, String nodeName) {
        this.node2NameMap.put(node, nodeName);
        this.name2NodeMap.put(nodeName, node);
    }

    @Override
    public String lookupInstanceName(Object node) {
        return this.node2NameMap.getOrDefault(node, "???");
    }

    @Override
    public <T> T getInstanceById(String id) throws NoSuchFieldException {
        Object node = this.name2NodeMap.get(id);
        if (node == null) {
            throw new NoSuchFieldException(id);
        }
        return (T)node;
    }

    @Override
    public void init() {
        this.node2NameMap.clear();
    }

    @Override
    public String getName() {
        return "nodeNameLookup";
    }
}

