/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.audit;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;

public class StructuredLogRecord {
    private Map map;
    private List<AuditRecord> auditList;
    private List<String> nodeNameList;

    public StructuredLogRecord(Map map) {
        this.setMap(map);
    }

    public final void setMap(Map map) {
        this.map = map;
        this.auditList = null;
        this.nodeNameList = null;
    }

    public long getLogTime() {
        return ((Number)this.map.get("logTime")).longValue();
    }

    public long getEventTime() {
        return ((Number)this.map.get("eventTime")).longValue();
    }

    public long getEndTime() {
        return ((Number)this.map.get("eventTime")).longValue();
    }

    public String getGroupingId() {
        return (String)this.map.get("groupingId");
    }

    public String getEventType() {
        return (String)this.map.get("event");
    }

    public List<Map> nodeLogs() {
        return (List)this.map.get("nodeLogs");
    }

    public List<AuditRecord> getAuditLogs() {
        if (this.auditList == null) {
            LongAdder accumulator = new LongAdder();
            this.auditList = ((List)this.map.get("nodeLogs")).stream().map(m -> {
                Map.Entry entry = m.entrySet().iterator().next();
                AuditRecord auditRecord = new AuditRecord(entry, accumulator.intValue());
                accumulator.increment();
                return auditRecord;
            }).collect(Collectors.toList());
        }
        return this.auditList;
    }

    public List<String> nodeNames() {
        if (this.nodeNameList == null) {
            this.nodeNameList = this.nodeLogs().stream().flatMap(f -> f.keySet().stream()).map(k -> (String)k).distinct().collect(Collectors.toList());
        }
        return this.nodeNameList;
    }

    public int logCount() {
        return this.nodeLogs().size();
    }

    public String toString() {
        return "EventLog{logTime=" + this.getLogTime() + ", groupingId=" + this.getGroupingId() + ", event=" + this.getEventType() + ", logCount=" + this.logCount() + ", auditLogs=" + this.getAuditLogs() + ", nodeLogs=" + this.nodeLogs() + ", nodeNames=" + this.nodeNames() + '}';
    }

    public static class AuditRecord {
        private final String nodeId;
        private final Map propertyMap;
        private final int sequenceNumber;

        public AuditRecord(String nodeId, Map propertyMap, int sequenceNumber) {
            this.nodeId = nodeId;
            this.propertyMap = propertyMap;
            this.sequenceNumber = sequenceNumber;
        }

        public AuditRecord(Map.Entry entry, int sequenceNumber) {
            this.nodeId = (String)entry.getKey();
            this.propertyMap = (Map)entry.getValue();
            this.sequenceNumber = sequenceNumber;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public Map getPropertyMap() {
            return this.propertyMap;
        }

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        public String toString() {
            return "AuditRecord{nodeId=" + this.nodeId + ", sequenceNumber=" + this.sequenceNumber + ", propertyMap=" + this.propertyMap + '}';
        }
    }
}

