/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.callback;

import com.fluxtion.runtime.EventProcessorBuilderService;
import com.fluxtion.runtime.annotations.OnEventHandler;
import com.fluxtion.runtime.annotations.builder.FluxtionIgnore;
import com.fluxtion.runtime.callback.Callback;
import com.fluxtion.runtime.event.Event;
import com.fluxtion.runtime.node.BaseNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractCallbackNode<R>
extends BaseNode
implements Event,
Callback<R> {
    public static int instanceFilterCounter = 0;
    private final int filterId;
    protected R data;
    @FluxtionIgnore
    private final List<R> dataQueue = new ArrayList<R>();

    public AbstractCallbackNode() {
        this.filterId = EventProcessorBuilderService.nextId(instanceFilterCounter++);
    }

    public AbstractCallbackNode(int filterId) {
        this.filterId = filterId;
    }

    @OnEventHandler(filterVariable="filterId")
    public boolean trigger(AbstractCallbackNode<R> callbackNode) {
        boolean matchSource;
        boolean bl = matchSource = callbackNode == this;
        if (matchSource) {
            this.data = this.dataQueue.isEmpty() ? null : this.dataQueue.remove(0);
        }
        return matchSource;
    }

    @Override
    public void fireCallback() {
        this.fireCallback((R)null);
    }

    @Override
    public void fireCallback(R data) {
        this.dataQueue.add(data);
        this.getContext().processReentrantEvent(this);
    }

    @Override
    public void fireCallback(Iterator<R> dataIterator) {
        while (dataIterator.hasNext()) {
            R nextItem = dataIterator.next();
            this.fireCallback(nextItem);
        }
    }

    @Override
    public void fireNewEventCycle(R data) {
        this.dataQueue.add(data);
        this.getContext().processAsNewEventCycle(this);
    }

    @Override
    public R get() {
        return this.data;
    }

    @Override
    public int filterId() {
        return this.filterId;
    }
}

