/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.callback;

import com.fluxtion.runtime.EventProcessorContext;
import com.fluxtion.runtime.EventProcessorContextListener;
import com.fluxtion.runtime.annotations.builder.FluxtionIgnore;
import com.fluxtion.runtime.callback.Callback;
import com.fluxtion.runtime.callback.EventDispatcher;
import com.fluxtion.runtime.callback.InstanceCallbackEvent;
import com.fluxtion.runtime.node.EventHandlerNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CallBackNode<R>
implements Callback<R>,
EventHandlerNode<InstanceCallbackEvent>,
EventProcessorContextListener {
    private final InstanceCallbackEvent event;
    protected R data;
    @FluxtionIgnore
    private final List<R> dataQueue = new ArrayList<R>();
    private EventDispatcher dispatcher;

    public CallBackNode(InstanceCallbackEvent event) {
        this.event = event;
    }

    public CallBackNode() {
        this.event = InstanceCallbackEvent.nextCallBackEvent();
    }

    @Override
    public void currentContext(EventProcessorContext currentContext) {
        this.dispatcher = currentContext.getEventDispatcher();
    }

    @Override
    public Class<? extends InstanceCallbackEvent> eventClass() {
        return this.event.getClass();
    }

    @Override
    public <E extends InstanceCallbackEvent> boolean onEvent(E e) {
        this.data = this.dataQueue.isEmpty() ? null : this.dataQueue.remove(0);
        return true;
    }

    @Override
    public void fireCallback() {
        this.fireCallback((R)null);
    }

    @Override
    public void fireCallback(R data) {
        this.dataQueue.add(data);
        this.dispatcher.processReentrantEvent(this.event);
    }

    @Override
    public void fireCallback(Iterator<R> dataIterator) {
        while (dataIterator.hasNext()) {
            R nextItem = dataIterator.next();
            this.fireCallback(nextItem);
        }
    }

    @Override
    public void fireNewEventCycle(R data) {
        this.dataQueue.add(data);
        this.dispatcher.processAsNewEventCycle(this.event);
    }

    @Override
    public R get() {
        return this.data;
    }
}

