/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.callback;

import com.fluxtion.runtime.callback.CallbackEvent;
import com.fluxtion.runtime.callback.DirtyStateMonitor;
import com.fluxtion.runtime.callback.EventProcessorCallbackInternal;
import com.fluxtion.runtime.callback.InternalEventProcessor;
import com.fluxtion.runtime.node.NamedNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public class CallbackDispatcherImpl
implements EventProcessorCallbackInternal,
NamedNode,
DirtyStateMonitor {
    public InternalEventProcessor eventProcessor;
    Deque<Supplier<Boolean>> myStack = new ArrayDeque<Supplier<Boolean>>();
    private boolean dispatching = false;

    @Override
    public void dispatchQueuedCallbacks() {
        if (this.eventProcessor != null) {
            while (!this.myStack.isEmpty()) {
                this.dispatching = true;
                Supplier<Boolean> callBackItem = this.myStack.peekFirst();
                if (callBackItem.get().booleanValue()) continue;
                this.myStack.remove(callBackItem);
            }
        }
        this.dispatching = false;
    }

    @Override
    public void fireCallback(int id) {
        SingleCallBackWrapper callBackWrapper = new SingleCallBackWrapper();
        callBackWrapper.setFilterId(id);
        this.myStack.add(callBackWrapper::dispatch);
    }

    @Override
    public <T> void fireCallback(int id, T item) {
        SingleCallBackWrapper callBackWrapper = new SingleCallBackWrapper();
        callBackWrapper.setFilterId(id);
        callBackWrapper.setData(item);
        this.myStack.add(callBackWrapper::dispatch);
    }

    @Override
    public <R> void fireIteratorCallback(int callbackId, Iterator<R> dataIterator) {
        IteratingCallbackWrapper callBackWrapper = new IteratingCallbackWrapper();
        callBackWrapper.setFilterId(callbackId);
        callBackWrapper.dataIterator = dataIterator;
        if (this.dispatching) {
            this.myStack.addFirst(callBackWrapper::dispatch);
        } else {
            this.myStack.add(callBackWrapper::dispatch);
        }
    }

    @Override
    public void processReentrantEvent(Object event) {
        SingleEventPublishWrapper callBackWrapper = new SingleEventPublishWrapper();
        callBackWrapper.data = event;
        this.myStack.addFirst(callBackWrapper::dispatch);
    }

    @Override
    public void processReentrantEvents(Iterable<Object> iterable) {
        IteratingEventPublishWrapper publishingWrapper = new IteratingEventPublishWrapper();
        publishingWrapper.dataIterator = iterable.iterator();
        this.myStack.addFirst(publishingWrapper::dispatch);
    }

    @Override
    public void queueReentrantEvent(Object event) {
        SingleEventPublishWrapper callBackWrapper = new SingleEventPublishWrapper();
        callBackWrapper.data = event;
        this.myStack.add(callBackWrapper::dispatch);
    }

    @Override
    public void processAsNewEventCycle(Object event) {
        this.eventProcessor.onEvent(event);
    }

    @Override
    public String getName() {
        return "callbackDispatcher";
    }

    @Override
    public boolean isDirty(Object node) {
        return node != null && this.eventProcessor.isDirty(node);
    }

    @Override
    public BooleanSupplier dirtySupplier(Object node) {
        return this.eventProcessor.dirtySupplier(node);
    }

    @Override
    public void markDirty(Object node) {
        this.eventProcessor.setDirty(node, true);
    }

    public <T> T getNodeById(String id) throws NoSuchFieldException {
        return this.eventProcessor.getNodeById(id);
    }

    @Override
    public void setEventProcessor(InternalEventProcessor eventProcessor) {
        this.eventProcessor = eventProcessor;
    }

    public String toString() {
        return "CallbackDispatcherImpl(eventProcessor=" + this.eventProcessor + ", myStack=" + this.myStack + ", dispatching=" + this.dispatching + ")";
    }

    private class IteratingEventPublishWrapper {
        Iterator<Object> dataIterator;

        private IteratingEventPublishWrapper() {
        }

        boolean dispatch() {
            if (this.dataIterator.hasNext()) {
                CallbackDispatcherImpl.this.eventProcessor.onEventInternal(this.dataIterator.next());
                return true;
            }
            return false;
        }
    }

    private class IteratingCallbackWrapper<T>
    extends CallbackEvent<T> {
        Iterator<T> dataIterator;
        private final CallbackEvent<T> callbackEvent = new CallbackEvent();

        private IteratingCallbackWrapper() {
        }

        boolean dispatch() {
            if (this.dataIterator.hasNext()) {
                this.callbackEvent.setData(this.dataIterator.next());
                this.callbackEvent.setFilterId(this.getFilterId());
                CallbackDispatcherImpl.this.eventProcessor.onEventInternal(this.callbackEvent);
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return "CallbackDispatcherImpl.IteratingCallbackWrapper(super=" + super.toString() + ", dataIterator=" + this.dataIterator + ", callbackEvent=" + this.callbackEvent + ")";
        }
    }

    private class SingleEventPublishWrapper<T> {
        T data;

        private SingleEventPublishWrapper() {
        }

        boolean dispatch() {
            CallbackDispatcherImpl.this.eventProcessor.onEventInternal(this.data);
            return false;
        }

        public String toString() {
            return "CallbackDispatcherImpl.SingleEventPublishWrapper(super=" + super.toString() + ", data=" + this.data + ")";
        }
    }

    private class SingleCallBackWrapper<T>
    extends CallbackEvent<T> {
        private final CallbackEvent<T> callbackEvent = new CallbackEvent();

        private SingleCallBackWrapper() {
        }

        boolean dispatch() {
            this.callbackEvent.setData(this.getData());
            this.callbackEvent.setFilterId(this.getFilterId());
            CallbackDispatcherImpl.this.eventProcessor.onEventInternal(this.callbackEvent);
            this.setData(null);
            this.setFilterId(Integer.MAX_VALUE);
            return false;
        }

        @Override
        public String toString() {
            return "CallbackDispatcherImpl.SingleCallBackWrapper(super=" + super.toString() + ", callbackEvent=" + this.callbackEvent + ")";
        }
    }
}

