/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.callback;

import com.fluxtion.runtime.annotations.Initialise;
import com.fluxtion.runtime.annotations.builder.Inject;
import com.fluxtion.runtime.callback.Callback;
import com.fluxtion.runtime.callback.CallbackDispatcher;
import com.fluxtion.runtime.callback.CallbackEvent;
import com.fluxtion.runtime.callback.DirtyStateMonitor;
import com.fluxtion.runtime.callback.EventDispatcher;
import com.fluxtion.runtime.dataflow.TriggeredFlowFunction;
import com.fluxtion.runtime.node.AbstractEventHandlerNode;
import com.fluxtion.runtime.node.NamedNode;
import java.util.Iterator;
import java.util.function.BooleanSupplier;

public class CallbackImpl<R, T extends CallbackEvent<?>>
extends AbstractEventHandlerNode<CallbackEvent>
implements TriggeredFlowFunction<R>,
NamedNode,
Callback<R>,
EventDispatcher {
    private final int callbackId;
    @Inject
    public DirtyStateMonitor dirtyStateMonitor;
    @Inject
    private final CallbackDispatcher callBackDispatcher;
    private CallbackEvent<R> event;
    private BooleanSupplier dirtyStateSupplier;

    public CallbackImpl(int callbackId, CallbackDispatcher callBackDispatcher) {
        super(callbackId);
        this.callbackId = callbackId;
        this.callBackDispatcher = callBackDispatcher;
    }

    public CallbackImpl(int callbackId) {
        this(callbackId, null);
    }

    @Override
    public Class<CallbackEvent> eventClass() {
        return CallbackEvent.class;
    }

    @Override
    public boolean onEvent(CallbackEvent e) {
        this.event = e;
        return true;
    }

    @Override
    public boolean hasChanged() {
        return this.dirtyStateSupplier.getAsBoolean();
    }

    @Initialise
    public void init() {
        this.dirtyStateSupplier = this.dirtyStateMonitor.dirtySupplier(this);
    }

    @Override
    public void parallel() {
    }

    @Override
    public boolean parallelCandidate() {
        return false;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public R get() {
        return this.event.getData();
    }

    @Override
    public void setUpdateTriggerNode(Object updateTriggerNode) {
    }

    @Override
    public void setPublishTriggerNode(Object publishTriggerNode) {
    }

    @Override
    public void setResetTriggerNode(Object resetTriggerNode) {
    }

    @Override
    public void setPublishTriggerOverrideNode(Object publishTriggerOverrideNode) {
    }

    @Override
    public void fireCallback() {
        this.callBackDispatcher.fireCallback(this.callbackId);
    }

    @Override
    public void fireCallback(R data) {
        this.callBackDispatcher.fireCallback(this.callbackId, data);
    }

    @Override
    public void fireCallback(Iterator<R> dataIterator) {
        this.callBackDispatcher.fireIteratorCallback(this.callbackId, dataIterator);
    }

    @Override
    public void fireNewEventCycle(R data) {
        this.callBackDispatcher.processAsNewEventCycle(this.event);
    }

    @Override
    public void processReentrantEvent(Object event) {
        this.callBackDispatcher.processReentrantEvent(event);
    }

    @Override
    public void processReentrantEvents(Iterable<Object> iterator) {
        this.callBackDispatcher.processReentrantEvents(iterator);
    }

    @Override
    public void queueReentrantEvent(Object event) {
        this.callBackDispatcher.queueReentrantEvent(event);
    }

    @Override
    public void processAsNewEventCycle(Object event) {
        this.callBackDispatcher.processAsNewEventCycle(event);
    }

    public String toString() {
        return "CallbackImpl(callbackId=" + this.callbackId + ", dirtyStateMonitor=" + this.dirtyStateMonitor + ", callBackDispatcher=" + this.callBackDispatcher + ", event=" + this.event + ", dirtyStateSupplier=" + this.dirtyStateSupplier + ")";
    }
}

