/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.aggregate.function;

import com.fluxtion.runtime.annotations.OnParentUpdate;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.dataflow.DoubleFlowFunction;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.IntFlowFunction;
import com.fluxtion.runtime.dataflow.LongFlowFunction;
import com.fluxtion.runtime.dataflow.TriggeredFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateDoubleFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateIntFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateLongFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.function.BucketedSlidingWindow;
import com.fluxtion.runtime.dataflow.function.AbstractFlowFunction;
import com.fluxtion.runtime.partition.LambdaReflection;

public class FixSizedSlidingWindow<T, R, S extends FlowFunction<T>, F extends AggregateFlowFunction<T, R, F>>
extends AbstractFlowFunction<T, R, S>
implements TriggeredFlowFunction<R> {
    private final LambdaReflection.SerializableSupplier<F> windowFunctionSupplier;
    private final int buckets;
    protected final transient BucketedSlidingWindow<T, R, F> windowFunction;
    private R value;

    public FixSizedSlidingWindow(S inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int buckets) {
        super(inputEventStream, null);
        this.windowFunctionSupplier = windowFunctionSupplier;
        this.buckets = buckets;
        this.windowFunction = new BucketedSlidingWindow(windowFunctionSupplier, buckets);
    }

    @Override
    public R get() {
        return this.value;
    }

    protected void cacheWindowValue() {
        this.value = this.windowFunction.get();
    }

    protected void aggregateInputValue(S inputEventStream) {
        this.windowFunction.aggregate(inputEventStream.get());
        this.windowFunction.roll();
        if (this.windowFunction.isAllBucketsFilled()) {
            this.cacheWindowValue();
            this.publishOverrideTriggered = !this.overridePublishTrigger & !this.overrideUpdateTrigger;
            this.inputStreamTriggered_1 = true;
            this.inputStreamTriggered = true;
        }
    }

    @Override
    @OnParentUpdate
    public void inputUpdated(S inputEventStream) {
        this.aggregateInputValue(inputEventStream);
        this.inputStreamTriggered_1 = false;
        this.inputStreamTriggered = false;
    }

    @OnTrigger
    public boolean triggered() {
        return this.fireEventUpdateNotification();
    }

    @Override
    protected void resetOperation() {
        this.windowFunction.init();
        this.value = null;
    }

    @Override
    public boolean isStatefulFunction() {
        return true;
    }

    public static class FixSizedSlidingLongWindow<F extends AggregateLongFlowFunction<F>>
    extends FixSizedSlidingWindow<Long, Long, LongFlowFunction, F>
    implements LongFlowFunction {
        private long value;
        private final transient BucketedSlidingWindow.BucketedSlidingWindowedLongFunction<F> primitiveSlidingFunction;

        public FixSizedSlidingLongWindow(LongFlowFunction inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int buckets) {
            super(inputEventStream, windowFunctionSupplier, buckets);
            this.primitiveSlidingFunction = new BucketedSlidingWindow.BucketedSlidingWindowedLongFunction<F>(windowFunctionSupplier, buckets);
        }

        @Override
        @OnParentUpdate
        public void inputUpdated(LongFlowFunction inputEventStream) {
            this.aggregateInputValue(inputEventStream);
            this.inputStreamTriggered_1 = false;
            this.inputStreamTriggered = false;
        }

        @Override
        public Long get() {
            return this.value;
        }

        @Override
        public long getAsLong() {
            return this.value;
        }

        @Override
        protected void cacheWindowValue() {
            this.value = this.primitiveSlidingFunction.getAsLong();
        }

        @Override
        protected void aggregateInputValue(LongFlowFunction inputEventStream) {
            this.primitiveSlidingFunction.aggregateLong(inputEventStream.getAsLong());
            this.primitiveSlidingFunction.roll();
            if (this.primitiveSlidingFunction.isAllBucketsFilled()) {
                this.cacheWindowValue();
                this.publishOverrideTriggered = !this.overridePublishTrigger & !this.overrideUpdateTrigger;
                this.inputStreamTriggered_1 = true;
                this.inputStreamTriggered = true;
            }
        }

        @Override
        protected void resetOperation() {
            this.windowFunction.init();
            this.value = 0L;
        }
    }

    public static class FixSizedSlidingDoubleWindow<F extends AggregateDoubleFlowFunction<F>>
    extends FixSizedSlidingWindow<Double, Double, DoubleFlowFunction, F>
    implements DoubleFlowFunction {
        private double value;
        private final transient BucketedSlidingWindow.BucketedSlidingWindowedDoubleFunction<F> primitiveSlidingFunction;

        public FixSizedSlidingDoubleWindow(DoubleFlowFunction inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int buckets) {
            super(inputEventStream, windowFunctionSupplier, buckets);
            this.primitiveSlidingFunction = new BucketedSlidingWindow.BucketedSlidingWindowedDoubleFunction<F>(windowFunctionSupplier, buckets);
        }

        @Override
        @OnParentUpdate
        public void inputUpdated(DoubleFlowFunction inputEventStream) {
            this.aggregateInputValue(inputEventStream);
            this.inputStreamTriggered_1 = false;
            this.inputStreamTriggered = false;
        }

        @Override
        public Double get() {
            return this.value;
        }

        @Override
        public double getAsDouble() {
            return this.value;
        }

        @Override
        protected void cacheWindowValue() {
            this.value = this.primitiveSlidingFunction.getAsDouble();
        }

        @Override
        protected void aggregateInputValue(DoubleFlowFunction inputEventStream) {
            this.primitiveSlidingFunction.aggregateDouble(inputEventStream.getAsDouble());
            this.primitiveSlidingFunction.roll();
            if (this.primitiveSlidingFunction.isAllBucketsFilled()) {
                this.cacheWindowValue();
                this.publishOverrideTriggered = !this.overridePublishTrigger & !this.overrideUpdateTrigger;
                this.inputStreamTriggered_1 = true;
                this.inputStreamTriggered = true;
            }
        }

        @Override
        protected void resetOperation() {
            this.windowFunction.init();
            this.value = 0.0;
        }
    }

    public static class FixSizedSlidingIntWindow<F extends AggregateIntFlowFunction<F>>
    extends FixSizedSlidingWindow<Integer, Integer, IntFlowFunction, F>
    implements IntFlowFunction {
        private int value;
        private final transient BucketedSlidingWindow.BucketedSlidingWindowedIntFunction<F> primitiveSlidingFunction;

        public FixSizedSlidingIntWindow(IntFlowFunction inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int buckets) {
            super(inputEventStream, windowFunctionSupplier, buckets);
            this.primitiveSlidingFunction = new BucketedSlidingWindow.BucketedSlidingWindowedIntFunction<F>(windowFunctionSupplier, buckets);
        }

        @Override
        @OnParentUpdate
        public void inputUpdated(IntFlowFunction inputEventStream) {
            this.aggregateInputValue(inputEventStream);
            this.inputStreamTriggered_1 = false;
            this.inputStreamTriggered = false;
        }

        @Override
        public Integer get() {
            return this.value;
        }

        @Override
        public int getAsInt() {
            return this.value;
        }

        @Override
        protected void cacheWindowValue() {
            this.value = this.primitiveSlidingFunction.getAsInt();
        }

        @Override
        protected void aggregateInputValue(IntFlowFunction inputEventStream) {
            this.primitiveSlidingFunction.aggregateInt(inputEventStream.getAsInt());
            this.primitiveSlidingFunction.roll();
            if (this.primitiveSlidingFunction.isAllBucketsFilled()) {
                this.cacheWindowValue();
                this.publishOverrideTriggered = !this.overridePublishTrigger & !this.overrideUpdateTrigger;
                this.inputStreamTriggered_1 = true;
                this.inputStreamTriggered = true;
            }
        }

        @Override
        protected void resetOperation() {
            this.windowFunction.init();
            this.value = 0;
        }
    }
}

