/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.aggregate.function;

import com.fluxtion.runtime.annotations.OnParentUpdate;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.dataflow.DoubleFlowFunction;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.IntFlowFunction;
import com.fluxtion.runtime.dataflow.LongFlowFunction;
import com.fluxtion.runtime.dataflow.TriggeredFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateDoubleFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateIntFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateLongFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.function.BucketedSlidingWindow;
import com.fluxtion.runtime.dataflow.function.AbstractFlowFunction;
import com.fluxtion.runtime.partition.LambdaReflection;
import com.fluxtion.runtime.time.FixedRateTrigger;

public class TimedSlidingWindow<T, R, S extends FlowFunction<T>, F extends AggregateFlowFunction<T, R, F>>
extends AbstractFlowFunction<T, R, S>
implements TriggeredFlowFunction<R> {
    private final LambdaReflection.SerializableSupplier<F> windowFunctionSupplier;
    private final int buckets;
    protected final transient BucketedSlidingWindow<T, R, F> windowFunction;
    public FixedRateTrigger rollTrigger;
    private R value;

    public TimedSlidingWindow(S inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int windowSizeMillis, int buckets) {
        this(inputEventStream, windowFunctionSupplier, buckets);
        this.rollTrigger = FixedRateTrigger.atMillis(windowSizeMillis);
    }

    public TimedSlidingWindow(S inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int buckets) {
        super(inputEventStream, null);
        this.windowFunctionSupplier = windowFunctionSupplier;
        this.buckets = buckets;
        this.windowFunction = new BucketedSlidingWindow(windowFunctionSupplier, buckets);
    }

    @Override
    public R get() {
        return this.value;
    }

    protected void cacheWindowValue() {
        this.value = this.windowFunction.get();
    }

    protected void aggregateInputValue(S inputEventStream) {
        this.windowFunction.aggregate(inputEventStream.get());
    }

    @OnParentUpdate
    public void timeTriggerFired(FixedRateTrigger rollTrigger) {
        this.windowFunction.roll(rollTrigger.getTriggerCount());
        if (this.windowFunction.isAllBucketsFilled()) {
            this.cacheWindowValue();
            this.publishOverrideTriggered = !this.overridePublishTrigger & !this.overrideUpdateTrigger;
            this.inputStreamTriggered_1 = true;
            this.inputStreamTriggered = true;
        }
    }

    @Override
    @OnParentUpdate
    public void inputUpdated(S inputEventStream) {
        this.aggregateInputValue(inputEventStream);
        this.inputStreamTriggered_1 = false;
        this.inputStreamTriggered = false;
    }

    @OnTrigger
    public boolean triggered() {
        return this.fireEventUpdateNotification();
    }

    @Override
    protected void resetOperation() {
        this.windowFunction.init();
        this.rollTrigger.init();
        this.value = null;
    }

    @Override
    public boolean isStatefulFunction() {
        return true;
    }

    public static class TimedSlidingWindowLongStream<F extends AggregateLongFlowFunction<F>>
    extends TimedSlidingWindow<Long, Long, LongFlowFunction, F>
    implements LongFlowFunction {
        private long value;
        private final transient BucketedSlidingWindow.BucketedSlidingWindowedLongFunction<F> intSlidingFunction;

        public TimedSlidingWindowLongStream(LongFlowFunction inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int windowSizeMillis, int buckets) {
            super(inputEventStream, windowFunctionSupplier, windowSizeMillis, buckets);
            this.intSlidingFunction = new BucketedSlidingWindow.BucketedSlidingWindowedLongFunction<F>(windowFunctionSupplier, buckets);
        }

        public TimedSlidingWindowLongStream(LongFlowFunction inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int buckets) {
            super(inputEventStream, windowFunctionSupplier, buckets);
            this.intSlidingFunction = new BucketedSlidingWindow.BucketedSlidingWindowedLongFunction<F>(windowFunctionSupplier, buckets);
        }

        @Override
        @OnParentUpdate
        public void timeTriggerFired(FixedRateTrigger rollTrigger) {
            this.intSlidingFunction.roll(rollTrigger.getTriggerCount());
            if (this.intSlidingFunction.isAllBucketsFilled()) {
                this.cacheWindowValue();
                this.inputStreamTriggered_1 = true;
                this.inputStreamTriggered = true;
            }
        }

        @Override
        public Long get() {
            return this.value;
        }

        @Override
        public long getAsLong() {
            return this.value;
        }

        @Override
        protected void cacheWindowValue() {
            this.value = this.intSlidingFunction.getAsLong();
        }

        @Override
        protected void aggregateInputValue(LongFlowFunction inputEventStream) {
            this.intSlidingFunction.aggregateLong(inputEventStream.getAsLong());
        }

        @Override
        protected void resetOperation() {
            this.intSlidingFunction.init();
            this.rollTrigger.init();
            this.value = 0L;
        }
    }

    public static class TimedSlidingWindowDoubleStream<F extends AggregateDoubleFlowFunction<F>>
    extends TimedSlidingWindow<Double, Double, DoubleFlowFunction, F>
    implements DoubleFlowFunction {
        private double value = Double.NaN;
        private final transient BucketedSlidingWindow.BucketedSlidingWindowedDoubleFunction<F> intSlidingFunction;

        public TimedSlidingWindowDoubleStream(DoubleFlowFunction inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int windowSizeMillis, int buckets) {
            super(inputEventStream, windowFunctionSupplier, windowSizeMillis, buckets);
            this.intSlidingFunction = new BucketedSlidingWindow.BucketedSlidingWindowedDoubleFunction<F>(windowFunctionSupplier, buckets);
        }

        public TimedSlidingWindowDoubleStream(DoubleFlowFunction inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int buckets) {
            super(inputEventStream, windowFunctionSupplier, buckets);
            this.intSlidingFunction = new BucketedSlidingWindow.BucketedSlidingWindowedDoubleFunction<F>(windowFunctionSupplier, buckets);
        }

        @Override
        @OnParentUpdate
        public void timeTriggerFired(FixedRateTrigger rollTrigger) {
            this.intSlidingFunction.roll(rollTrigger.getTriggerCount());
            if (this.intSlidingFunction.isAllBucketsFilled()) {
                this.cacheWindowValue();
                this.inputStreamTriggered_1 = true;
                this.inputStreamTriggered = true;
            }
        }

        @Override
        public Double get() {
            return this.value;
        }

        @Override
        public double getAsDouble() {
            return this.value;
        }

        @Override
        protected void cacheWindowValue() {
            this.value = this.intSlidingFunction.getAsDouble();
        }

        @Override
        protected void aggregateInputValue(DoubleFlowFunction inputEventStream) {
            this.intSlidingFunction.aggregateDouble(inputEventStream.getAsDouble());
        }

        @Override
        protected void resetOperation() {
            this.intSlidingFunction.init();
            this.rollTrigger.init();
            this.value = Double.NaN;
        }
    }

    public static class TimedSlidingWindowIntStream<F extends AggregateIntFlowFunction<F>>
    extends TimedSlidingWindow<Integer, Integer, IntFlowFunction, F>
    implements IntFlowFunction {
        private int value;
        private final transient BucketedSlidingWindow.BucketedSlidingWindowedIntFunction<F> intSlidingFunction;

        public TimedSlidingWindowIntStream(IntFlowFunction inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int windowSizeMillis, int buckets) {
            super(inputEventStream, windowFunctionSupplier, windowSizeMillis, buckets);
            this.intSlidingFunction = new BucketedSlidingWindow.BucketedSlidingWindowedIntFunction<F>(windowFunctionSupplier, buckets);
        }

        public TimedSlidingWindowIntStream(IntFlowFunction inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int buckets) {
            super(inputEventStream, windowFunctionSupplier, buckets);
            this.intSlidingFunction = new BucketedSlidingWindow.BucketedSlidingWindowedIntFunction<F>(windowFunctionSupplier, buckets);
        }

        @Override
        @OnParentUpdate
        public void timeTriggerFired(FixedRateTrigger rollTrigger) {
            this.intSlidingFunction.roll(rollTrigger.getTriggerCount());
            if (this.intSlidingFunction.isAllBucketsFilled()) {
                this.cacheWindowValue();
                this.inputStreamTriggered_1 = true;
                this.inputStreamTriggered = true;
            }
        }

        @Override
        public Integer get() {
            return this.value;
        }

        @Override
        public int getAsInt() {
            return this.value;
        }

        @Override
        protected void cacheWindowValue() {
            this.value = this.intSlidingFunction.getAsInt();
        }

        @Override
        protected void aggregateInputValue(IntFlowFunction inputEventStream) {
            this.intSlidingFunction.aggregateInt(inputEventStream.getAsInt());
        }

        @Override
        protected void resetOperation() {
            this.intSlidingFunction.init();
            this.rollTrigger.init();
            this.value = 0;
        }
    }
}

