/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.aggregate.function;

import com.fluxtion.runtime.annotations.OnParentUpdate;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.dataflow.DoubleFlowFunction;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.IntFlowFunction;
import com.fluxtion.runtime.dataflow.LongFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateDoubleFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateIntFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateLongFlowFunction;
import com.fluxtion.runtime.dataflow.function.AbstractFlowFunction;
import com.fluxtion.runtime.partition.LambdaReflection;
import com.fluxtion.runtime.time.FixedRateTrigger;

public class TumblingWindow<T, R, S extends FlowFunction<T>, F extends AggregateFlowFunction<T, R, F>>
extends AbstractFlowFunction<T, R, S> {
    private final LambdaReflection.SerializableSupplier<F> windowFunctionSupplier;
    protected final transient F windowFunction;
    public FixedRateTrigger rollTrigger;
    private R value;

    public TumblingWindow(S inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int windowSizeMillis) {
        this(inputEventStream, windowFunctionSupplier);
        this.rollTrigger = FixedRateTrigger.atMillis(windowSizeMillis);
    }

    public TumblingWindow(S inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier) {
        super(inputEventStream, null);
        this.windowFunctionSupplier = windowFunctionSupplier;
        this.windowFunction = (AggregateFlowFunction)windowFunctionSupplier.get();
    }

    @Override
    public R get() {
        return this.value;
    }

    protected void cacheWindowValue() {
        this.value = this.windowFunction.get();
    }

    protected void aggregateInputValue(S inputEventStream) {
        this.windowFunction.aggregate(inputEventStream.get());
    }

    @OnParentUpdate
    public void timeTriggerFired(FixedRateTrigger rollTrigger) {
        if (rollTrigger.getTriggerCount() == 1) {
            this.cacheWindowValue();
        }
        this.publishOverrideTriggered = !this.overridePublishTrigger & !this.overrideUpdateTrigger;
        this.inputStreamTriggered_1 = true;
        this.inputStreamTriggered = true;
        this.windowFunction.reset();
        if (rollTrigger.getTriggerCount() != 1) {
            this.cacheWindowValue();
        }
    }

    @Override
    @OnParentUpdate
    public void inputUpdated(S inputEventStream) {
        this.aggregateInputValue(inputEventStream);
        this.inputStreamTriggered_1 = false;
        this.inputStreamTriggered = false;
    }

    @Override
    @OnParentUpdate(value="updateTriggerNode")
    public void updateTriggerNodeUpdated(Object triggerNode) {
        super.updateTriggerNodeUpdated(triggerNode);
        this.cacheWindowValue();
    }

    @OnTrigger
    public boolean triggered() {
        return this.fireEventUpdateNotification();
    }

    @Override
    protected void resetOperation() {
        this.windowFunction.reset();
        this.rollTrigger.init();
        this.value = null;
    }

    @Override
    public boolean isStatefulFunction() {
        return true;
    }

    public static class TumblingLongWindowStream<F extends AggregateLongFlowFunction<F>>
    extends TumblingWindow<Long, Long, LongFlowFunction, F>
    implements LongFlowFunction {
        private long value;

        public TumblingLongWindowStream(LongFlowFunction inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int windowSizeMillis) {
            super(inputEventStream, windowFunctionSupplier, windowSizeMillis);
        }

        public TumblingLongWindowStream(LongFlowFunction inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier) {
            super(inputEventStream, windowFunctionSupplier);
        }

        @Override
        public long getAsLong() {
            return this.value;
        }

        @Override
        public Long get() {
            return this.value;
        }

        @Override
        protected void cacheWindowValue() {
            this.value = ((AggregateLongFlowFunction)this.windowFunction).getAsLong();
        }

        @Override
        protected void aggregateInputValue(LongFlowFunction inputEventStream) {
            ((AggregateLongFlowFunction)this.windowFunction).aggregateLong(inputEventStream.getAsLong());
        }
    }

    public static class TumblingDoubleWindowStream<F extends AggregateDoubleFlowFunction<F>>
    extends TumblingWindow<Double, Double, DoubleFlowFunction, F>
    implements DoubleFlowFunction {
        private double value;

        public TumblingDoubleWindowStream(DoubleFlowFunction inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int windowSizeMillis) {
            super(inputEventStream, windowFunctionSupplier, windowSizeMillis);
        }

        public TumblingDoubleWindowStream(DoubleFlowFunction inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier) {
            super(inputEventStream, windowFunctionSupplier);
        }

        @Override
        public double getAsDouble() {
            return this.value;
        }

        @Override
        public Double get() {
            return this.value;
        }

        @Override
        protected void cacheWindowValue() {
            this.value = ((AggregateDoubleFlowFunction)this.windowFunction).getAsDouble();
        }

        @Override
        protected void aggregateInputValue(DoubleFlowFunction inputEventStream) {
            ((AggregateDoubleFlowFunction)this.windowFunction).aggregateDouble(inputEventStream.getAsDouble());
        }
    }

    public static class TumblingIntWindowStream<F extends AggregateIntFlowFunction<F>>
    extends TumblingWindow<Integer, Integer, IntFlowFunction, F>
    implements IntFlowFunction {
        private int value;

        public TumblingIntWindowStream(IntFlowFunction inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int windowSizeMillis) {
            super(inputEventStream, windowFunctionSupplier, windowSizeMillis);
        }

        public TumblingIntWindowStream(IntFlowFunction inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier) {
            super(inputEventStream, windowFunctionSupplier);
        }

        @Override
        public int getAsInt() {
            return this.value;
        }

        @Override
        public Integer get() {
            return this.value;
        }

        @Override
        protected void cacheWindowValue() {
            this.value = ((AggregateIntFlowFunction)this.windowFunction).getAsInt();
        }

        @Override
        protected void aggregateInputValue(IntFlowFunction inputEventStream) {
            ((AggregateIntFlowFunction)this.windowFunction).aggregateInt(inputEventStream.getAsInt());
        }
    }
}

