/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.aggregate.function.primitive;

import com.fluxtion.runtime.annotations.Initialise;
import com.fluxtion.runtime.annotations.builder.Inject;
import com.fluxtion.runtime.callback.DirtyStateMonitor;
import com.fluxtion.runtime.dataflow.IntFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateFlowFunction;
import java.util.function.BooleanSupplier;

public class CountFlowFunction<T>
implements AggregateFlowFunction<T, Integer, CountFlowFunction<T>>,
IntFlowFunction {
    private int count;
    @Inject
    private final DirtyStateMonitor dirtyStateMonitor;
    private BooleanSupplier dirtySupplier;

    public CountFlowFunction(DirtyStateMonitor dirtyStateMonitor) {
        this.dirtyStateMonitor = dirtyStateMonitor;
    }

    public CountFlowFunction() {
        this(null);
    }

    @Initialise
    public void init() {
        this.dirtySupplier = this.dirtyStateMonitor.dirtySupplier(this);
    }

    @Override
    public Integer reset() {
        this.count = 0;
        return this.get();
    }

    @Override
    public void parallel() {
    }

    @Override
    public boolean parallelCandidate() {
        return false;
    }

    @Override
    public int getAsInt() {
        return this.count;
    }

    @Override
    public Integer get() {
        return this.getAsInt();
    }

    @Override
    public Integer aggregate(T input) {
        return ++this.count;
    }

    public int increment(int input) {
        ++this.count;
        return this.getAsInt();
    }

    @Override
    public void combine(CountFlowFunction<T> add) {
        this.count += add.count;
    }

    @Override
    public void deduct(CountFlowFunction<T> add) {
        this.count -= add.count;
    }

    public int increment(double input) {
        return this.increment(1);
    }

    public int increment(long input) {
        return this.increment(1);
    }

    @Override
    public boolean hasChanged() {
        return this.dirtySupplier.getAsBoolean();
    }
}

