/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.function;

import com.fluxtion.runtime.annotations.Initialise;
import com.fluxtion.runtime.annotations.OnParentUpdate;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.dataflow.FlowSupplier;
import com.fluxtion.runtime.dataflow.TriggeredFlowFunction;
import com.fluxtion.runtime.node.BaseNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;

public abstract class BaseFlowNode<T>
extends BaseNode
implements TriggeredFlowFunction<T> {
    protected transient boolean overrideUpdateTrigger;
    protected transient boolean overridePublishTrigger;
    protected transient boolean inputStreamTriggered;
    protected transient boolean overrideTriggered;
    protected transient boolean publishTriggered;
    protected transient boolean publishOverrideTriggered;
    protected transient boolean resetTriggered;
    private Object updateTriggerNode;
    private Object publishTriggerNode;
    private Object publishTriggerOverrideNode;
    private Object resetTriggerNode;
    private BooleanSupplier dirtySupplier;
    protected List<FlowSupplier<?>> inputs = new ArrayList();
    private final transient Set<FlowSupplier<?>> requiredSet = new HashSet();
    private transient boolean allTriggersUpdated = false;

    @Initialise
    public final void initialiseEventStream() {
        this.overrideUpdateTrigger = this.updateTriggerNode != null;
        this.overridePublishTrigger = this.publishTriggerOverrideNode != null;
        this.dirtySupplier = this.getContext().getDirtyStateMonitor().dirtySupplier(this);
        this.requiredSet.addAll(this.inputs);
        this.initialise();
    }

    protected void initialise() {
    }

    protected abstract boolean isStatefulFunction();

    @Override
    public boolean parallelCandidate() {
        return false;
    }

    @OnParentUpdate(value="inputs")
    public void inputUpdated(FlowSupplier<?> inputEventStream) {
        if (!this.allTriggersUpdated) {
            this.requiredSet.remove(inputEventStream);
            this.allTriggersUpdated = this.requiredSet.isEmpty();
        }
        this.inputStreamTriggered = !this.resetTriggered & this.allTriggersUpdated;
    }

    @OnParentUpdate(value="updateTriggerNode")
    public void updateTriggerNodeUpdated(Object triggerNode) {
        this.overrideTriggered = true;
    }

    @OnParentUpdate(value="publishTriggerNode")
    public final void publishTriggerNodeUpdated(Object triggerNode) {
        this.publishTriggered = true;
    }

    @OnParentUpdate(value="publishTriggerOverrideNode")
    public final void publishTriggerOverrideNodeUpdated(Object triggerNode) {
        this.publishOverrideTriggered = true;
    }

    @OnParentUpdate(value="resetTriggerNode")
    public final void resetTriggerNodeUpdated(Object triggerNode) {
        this.resetTriggered = true;
        this.inputStreamTriggered = false;
        if (this.isStatefulFunction()) {
            this.resetOperation();
        }
        this.requiredSet.addAll(this.inputs);
    }

    protected abstract void resetOperation();

    @OnTrigger
    public final boolean trigger() {
        if (this.executeUpdate()) {
            this.auditLog.info("invokeTriggerOperation", true);
            this.triggerOperation();
        } else {
            this.auditLog.info("invokeTriggerOperation", false);
        }
        return this.fireEventUpdateNotification();
    }

    protected abstract void triggerOperation();

    protected boolean fireEventUpdateNotification() {
        boolean fireNotification = (!this.overridePublishTrigger && !this.overrideUpdateTrigger && this.inputStreamTriggered) | (!this.overridePublishTrigger && this.overrideTriggered) | this.publishOverrideTriggered | this.publishTriggered | this.resetTriggered;
        this.overrideTriggered = false;
        this.publishTriggered = false;
        this.publishOverrideTriggered = false;
        this.resetTriggered = false;
        this.inputStreamTriggered = false;
        this.auditLog.info("fireNotification", fireNotification);
        return fireNotification && this.get() != null;
    }

    protected boolean executeUpdate() {
        return (!this.overrideUpdateTrigger && this.inputStreamTriggered) | this.overrideTriggered;
    }

    @Override
    public void parallel() {
    }

    @Override
    public boolean hasChanged() {
        return this.dirtySupplier.getAsBoolean();
    }

    public boolean isOverrideUpdateTrigger() {
        return this.overrideUpdateTrigger;
    }

    public boolean isOverridePublishTrigger() {
        return this.overridePublishTrigger;
    }

    public boolean isInputStreamTriggered() {
        return this.inputStreamTriggered;
    }

    public boolean isOverrideTriggered() {
        return this.overrideTriggered;
    }

    public boolean isPublishTriggered() {
        return this.publishTriggered;
    }

    public boolean isPublishOverrideTriggered() {
        return this.publishOverrideTriggered;
    }

    public boolean isResetTriggered() {
        return this.resetTriggered;
    }

    public Object getUpdateTriggerNode() {
        return this.updateTriggerNode;
    }

    public Object getPublishTriggerNode() {
        return this.publishTriggerNode;
    }

    public Object getPublishTriggerOverrideNode() {
        return this.publishTriggerOverrideNode;
    }

    public Object getResetTriggerNode() {
        return this.resetTriggerNode;
    }

    public BooleanSupplier getDirtySupplier() {
        return this.dirtySupplier;
    }

    public List<FlowSupplier<?>> getInputs() {
        return this.inputs;
    }

    public Set<FlowSupplier<?>> getRequiredSet() {
        return this.requiredSet;
    }

    public boolean isAllTriggersUpdated() {
        return this.allTriggersUpdated;
    }

    public void setOverrideUpdateTrigger(boolean overrideUpdateTrigger) {
        this.overrideUpdateTrigger = overrideUpdateTrigger;
    }

    public void setOverridePublishTrigger(boolean overridePublishTrigger) {
        this.overridePublishTrigger = overridePublishTrigger;
    }

    public void setInputStreamTriggered(boolean inputStreamTriggered) {
        this.inputStreamTriggered = inputStreamTriggered;
    }

    public void setOverrideTriggered(boolean overrideTriggered) {
        this.overrideTriggered = overrideTriggered;
    }

    public void setPublishTriggered(boolean publishTriggered) {
        this.publishTriggered = publishTriggered;
    }

    public void setPublishOverrideTriggered(boolean publishOverrideTriggered) {
        this.publishOverrideTriggered = publishOverrideTriggered;
    }

    public void setResetTriggered(boolean resetTriggered) {
        this.resetTriggered = resetTriggered;
    }

    @Override
    public void setUpdateTriggerNode(Object updateTriggerNode) {
        this.updateTriggerNode = updateTriggerNode;
    }

    @Override
    public void setPublishTriggerNode(Object publishTriggerNode) {
        this.publishTriggerNode = publishTriggerNode;
    }

    @Override
    public void setPublishTriggerOverrideNode(Object publishTriggerOverrideNode) {
        this.publishTriggerOverrideNode = publishTriggerOverrideNode;
    }

    @Override
    public void setResetTriggerNode(Object resetTriggerNode) {
        this.resetTriggerNode = resetTriggerNode;
    }

    public void setDirtySupplier(BooleanSupplier dirtySupplier) {
        this.dirtySupplier = dirtySupplier;
    }

    public void setInputs(List<FlowSupplier<?>> inputs) {
        this.inputs = inputs;
    }

    public void setAllTriggersUpdated(boolean allTriggersUpdated) {
        this.allTriggersUpdated = allTriggersUpdated;
    }
}

