/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.function;

import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.annotations.builder.AssignToField;
import com.fluxtion.runtime.dataflow.DefaultValueSupplier;
import com.fluxtion.runtime.dataflow.DoubleFlowFunction;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.IntFlowFunction;
import com.fluxtion.runtime.dataflow.LongFlowFunction;
import com.fluxtion.runtime.dataflow.function.AbstractFlowFunction;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.lang.reflect.Method;

public abstract class BinaryMapFlowFunction<R, Q, T, S extends FlowFunction<R>, U extends FlowFunction<Q>>
extends AbstractFlowFunction.AbstractBinaryEventStream<R, Q, T, S, U> {
    protected transient String auditInfo;
    protected transient T result;
    protected T defaultValue;

    public BinaryMapFlowFunction(S inputEventStream, U inputEventStream_2, LambdaReflection.MethodReferenceReflection methodReferenceReflection) {
        super(inputEventStream, inputEventStream_2, methodReferenceReflection);
        Method method = methodReferenceReflection.method();
        this.auditInfo = method.getDeclaringClass().getSimpleName() + "->" + method.getName();
    }

    @OnTrigger
    public final boolean map() {
        this.auditLog.info("mapFunction", this.auditInfo);
        if (this.executeUpdate()) {
            this.auditLog.info("invokeMapFunction", true);
            this.mapOperation();
        } else if (this.reset()) {
            this.auditLog.info("invokeMapFunction", false);
            this.auditLog.info("reset", true);
        } else {
            this.auditLog.info("invokeMapFunction", false);
        }
        return this.fireEventUpdateNotification();
    }

    @Override
    public boolean hasDefaultValue() {
        return this.defaultValue != null | DefaultValueSupplier.class.isAssignableFrom(this.getStreamFunction().method().getDeclaringClass());
    }

    @Override
    public T get() {
        return this.result == null ? this.defaultValue : this.result;
    }

    protected abstract void mapOperation();

    @Override
    protected void resetOperation() {
        this.inputStreamTriggered_2 = false;
        if (this.resetFunction != null) {
            this.result = this.resetFunction.reset();
        }
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public BinaryMapFlowFunction<R, Q, T, S, U> defaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public static class BinaryMapToLongFlowFunction<S extends LongFlowFunction, U extends LongFlowFunction>
    extends BinaryMapFlowFunction<Long, Long, Long, S, U>
    implements LongFlowFunction {
        protected transient long result;
        private final LambdaReflection.SerializableBiLongFunction mapFunction;

        public BinaryMapToLongFlowFunction(@AssignToField(value="inputEventStream") S inputEventStream_1, @AssignToField(value="inputEventStream_2") U inputEventStream_2, @AssignToField(value="mapFunction") LambdaReflection.SerializableBiLongFunction methodReferenceReflection) {
            super(inputEventStream_1, inputEventStream_2, methodReferenceReflection);
            this.mapFunction = methodReferenceReflection;
        }

        @Override
        protected void mapOperation() {
            this.result = this.mapFunction.applyAsLong(((LongFlowFunction)this.getInputEventStream_1()).getAsLong(), ((LongFlowFunction)this.getInputEventStream_2()).getAsLong());
        }

        @Override
        public Long get() {
            return this.getAsLong();
        }

        @Override
        public long getAsLong() {
            return this.result;
        }
    }

    public static class BinaryMapToDoubleFlowFunction<S extends DoubleFlowFunction, U extends DoubleFlowFunction>
    extends BinaryMapFlowFunction<Double, Double, Double, S, U>
    implements DoubleFlowFunction {
        protected transient double result;
        private final LambdaReflection.SerializableBiDoubleFunction mapFunction;

        public BinaryMapToDoubleFlowFunction(@AssignToField(value="inputEventStream") S inputEventStream_1, @AssignToField(value="inputEventStream_2") U inputEventStream_2, @AssignToField(value="mapFunction") LambdaReflection.SerializableBiDoubleFunction methodReferenceReflection) {
            super(inputEventStream_1, inputEventStream_2, methodReferenceReflection);
            this.mapFunction = methodReferenceReflection;
        }

        @Override
        protected void mapOperation() {
            this.result = this.mapFunction.applyAsDouble(((DoubleFlowFunction)this.getInputEventStream_1()).getAsDouble(), ((DoubleFlowFunction)this.getInputEventStream_2()).getAsDouble());
        }

        @Override
        public Double get() {
            return this.getAsDouble();
        }

        @Override
        public double getAsDouble() {
            return this.result;
        }
    }

    public static class BinaryMapToIntFlowFunction<S extends IntFlowFunction, U extends IntFlowFunction>
    extends BinaryMapFlowFunction<Integer, Integer, Integer, S, U>
    implements IntFlowFunction {
        protected transient int result;
        private final LambdaReflection.SerializableBiIntFunction mapFunction;

        public BinaryMapToIntFlowFunction(@AssignToField(value="inputEventStream") S inputEventStream_1, @AssignToField(value="inputEventStream_2") U inputEventStream_2, @AssignToField(value="mapFunction") LambdaReflection.SerializableBiIntFunction methodReferenceReflection) {
            super(inputEventStream_1, inputEventStream_2, methodReferenceReflection);
            this.mapFunction = methodReferenceReflection;
        }

        @Override
        protected void mapOperation() {
            this.result = this.mapFunction.applyAsInt(((IntFlowFunction)this.getInputEventStream_1()).getAsInt(), ((IntFlowFunction)this.getInputEventStream_2()).getAsInt());
        }

        @Override
        public Integer get() {
            return this.getAsInt();
        }

        @Override
        public int getAsInt() {
            return this.result;
        }
    }

    public static class BinaryMapToRefFlowFunction<R, Q, T, S extends FlowFunction<R>, U extends FlowFunction<Q>>
    extends BinaryMapFlowFunction<R, Q, T, S, U> {
        private final LambdaReflection.SerializableBiFunction<R, Q, T> mapFunction;

        public BinaryMapToRefFlowFunction(@AssignToField(value="inputEventStream") S inputEventStream_1, @AssignToField(value="inputEventStream_2") U inputEventStream_2, @AssignToField(value="mapFunction") LambdaReflection.SerializableBiFunction<R, Q, T> methodReferenceReflection) {
            super(inputEventStream_1, inputEventStream_2, methodReferenceReflection);
            this.mapFunction = methodReferenceReflection;
        }

        @Override
        protected void mapOperation() {
            this.result = this.mapFunction.apply(this.getInputEventStream_1().get(), this.getInputEventStream_2().get());
        }
    }
}

