/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.function;

import com.fluxtion.runtime.annotations.NoTriggerReference;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.annotations.builder.AssignToField;
import com.fluxtion.runtime.dataflow.DoubleFlowFunction;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.IntFlowFunction;
import com.fluxtion.runtime.dataflow.LongFlowFunction;
import com.fluxtion.runtime.dataflow.function.AbstractFlowFunction;
import com.fluxtion.runtime.partition.LambdaReflection;

public class FilterDynamicFlowFunction<T, A, S extends FlowFunction<T>, B extends FlowFunction<A>>
extends AbstractFlowFunction.AbstractBinaryEventStream<T, A, T, S, B> {
    final LambdaReflection.SerializableBiFunction<T, A, Boolean> filterFunction;
    final transient String auditInfo;

    public FilterDynamicFlowFunction(@AssignToField(value="inputEventStream") S inputEventStream, @AssignToField(value="inputEventStream_2") B inputEventStream_2, LambdaReflection.SerializableBiFunction<T, A, Boolean> filterFunction) {
        super(inputEventStream, inputEventStream_2, filterFunction);
        this.filterFunction = filterFunction;
        this.auditInfo = filterFunction.method().getDeclaringClass().getSimpleName() + "->" + filterFunction.method().getName();
    }

    @OnTrigger
    public boolean filter() {
        boolean filter = this.inputStreamTriggered_1 & this.inputStreamTriggered_2 && (this.isPublishTriggered() || (Boolean)this.filterFunction.apply(this.getInputEventStream().get(), this.secondArgument()) != false);
        boolean fireNotification = filter & this.fireEventUpdateNotification();
        this.auditLog.info("filterFunction", this.auditInfo);
        this.auditLog.info("filterPass", filter);
        this.auditLog.info("publishToChild", fireNotification);
        return fireNotification;
    }

    @Override
    public T get() {
        return this.getInputEventStream().get();
    }

    private A secondArgument() {
        return (A)this.getInputEventStream_2().get();
    }

    public static class LongFilterDynamicFlowFunction
    extends AbstractFlowFunction.AbstractBinaryEventStream<Long, Long, Long, LongFlowFunction, LongFlowFunction>
    implements LongFlowFunction {
        final transient String auditInfo;
        private final LambdaReflection.SerializableBiLongPredicate filterFunction;

        public LongFilterDynamicFlowFunction(@AssignToField(value="inputEventStream") LongFlowFunction inputEventStream, @AssignToField(value="inputEventStream_2") LongFlowFunction inputEventStream_2, LambdaReflection.SerializableBiLongPredicate filterFunction) {
            super(inputEventStream, inputEventStream_2, filterFunction);
            this.filterFunction = filterFunction;
            this.auditInfo = filterFunction.method().getDeclaringClass().getSimpleName() + "->" + filterFunction.method().getName();
        }

        @OnTrigger
        public boolean filter() {
            boolean filter = this.inputStreamTriggered_1 & this.inputStreamTriggered_2 && (this.isPublishTriggered() || this.filterFunction.apply(((LongFlowFunction)this.getInputEventStream()).getAsLong(), ((LongFlowFunction)this.getInputEventStream_2()).getAsLong()));
            boolean fireNotification = filter & this.fireEventUpdateNotification();
            this.auditLog.info("filterFunction", this.auditInfo);
            this.auditLog.info("filterPass", filter);
            this.auditLog.info("publishToChild", fireNotification);
            return fireNotification;
        }

        @Override
        public Long get() {
            return this.getAsLong();
        }

        @Override
        public long getAsLong() {
            return ((LongFlowFunction)this.getInputEventStream()).getAsLong();
        }
    }

    public static class DoubleFilterDynamicFlowFunction
    extends AbstractFlowFunction.AbstractBinaryEventStream<Double, Double, Double, DoubleFlowFunction, DoubleFlowFunction>
    implements DoubleFlowFunction {
        final transient String auditInfo;
        @NoTriggerReference
        private final LambdaReflection.SerializableBiDoublePredicate filterFunction;

        public DoubleFilterDynamicFlowFunction(@AssignToField(value="inputEventStream") DoubleFlowFunction inputEventStream, @AssignToField(value="inputEventStream_2") DoubleFlowFunction inputEventStream_2, LambdaReflection.SerializableBiDoublePredicate filterFunction) {
            super(inputEventStream, inputEventStream_2, filterFunction);
            this.filterFunction = filterFunction;
            this.auditInfo = filterFunction.method().getDeclaringClass().getSimpleName() + "->" + filterFunction.method().getName();
        }

        @OnTrigger
        public boolean filter() {
            boolean filter = this.inputStreamTriggered_1 & this.inputStreamTriggered_2 && (this.isPublishTriggered() || this.filterFunction.apply(((DoubleFlowFunction)this.getInputEventStream()).getAsDouble(), ((DoubleFlowFunction)this.getInputEventStream_2()).getAsDouble()));
            boolean fireNotification = filter & this.fireEventUpdateNotification();
            this.auditLog.info("filterFunction", this.auditInfo);
            this.auditLog.info("filterPass", filter);
            this.auditLog.info("publishToChild", fireNotification);
            return fireNotification;
        }

        @Override
        public Double get() {
            return this.getAsDouble();
        }

        @Override
        public double getAsDouble() {
            return ((DoubleFlowFunction)this.getInputEventStream()).getAsDouble();
        }
    }

    public static class IntFilterDynamicFlowFunction
    extends AbstractFlowFunction.AbstractBinaryEventStream<Integer, Integer, Integer, IntFlowFunction, IntFlowFunction>
    implements IntFlowFunction {
        final transient String auditInfo;
        private final LambdaReflection.SerializableBiIntPredicate filterFunction;

        public IntFilterDynamicFlowFunction(@AssignToField(value="inputEventStream") IntFlowFunction inputEventStream, @AssignToField(value="inputEventStream_2") IntFlowFunction inputEventStream_2, LambdaReflection.SerializableBiIntPredicate filterFunction) {
            super(inputEventStream, inputEventStream_2, filterFunction);
            this.filterFunction = filterFunction;
            this.auditInfo = filterFunction.method().getDeclaringClass().getSimpleName() + "->" + filterFunction.method().getName();
        }

        @OnTrigger
        public boolean filter() {
            boolean filter = this.inputStreamTriggered_1 & this.inputStreamTriggered_2 && (this.isPublishTriggered() || this.filterFunction.apply(((IntFlowFunction)this.getInputEventStream()).getAsInt(), ((IntFlowFunction)this.getInputEventStream_2()).getAsInt()));
            boolean fireNotification = filter & this.fireEventUpdateNotification();
            this.auditLog.info("filterFunction", this.auditInfo);
            this.auditLog.info("filterPass", filter);
            this.auditLog.info("publishToChild", fireNotification);
            return fireNotification;
        }

        @Override
        public Integer get() {
            return this.getAsInt();
        }

        @Override
        public int getAsInt() {
            return ((IntFlowFunction)this.getInputEventStream()).getAsInt();
        }
    }
}

