/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.function;

import com.fluxtion.runtime.EventProcessorBuilderService;
import com.fluxtion.runtime.annotations.NoTriggerReference;
import com.fluxtion.runtime.annotations.OnParentUpdate;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.annotations.builder.Inject;
import com.fluxtion.runtime.callback.Callback;
import com.fluxtion.runtime.callback.DirtyStateMonitor;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.TriggeredFlowFunction;
import com.fluxtion.runtime.node.BaseNode;
import com.fluxtion.runtime.partition.LambdaReflection;

public class FlatMapFlowFunction<T, R, S extends FlowFunction<T>>
extends BaseNode
implements TriggeredFlowFunction<R> {
    @NoTriggerReference
    private final S inputEventStream;
    @NoTriggerReference
    private final transient Object streamFunctionInstance;
    private final LambdaReflection.SerializableFunction<T, Iterable<R>> iterableFunction;
    private transient R value;
    @Inject
    public Callback<R> callback;
    @Inject
    public DirtyStateMonitor dirtyStateMonitor;
    private String flatMapCompleteSignal;

    public FlatMapFlowFunction(S inputEventStream, LambdaReflection.SerializableFunction<T, Iterable<R>> iterableFunction) {
        this.inputEventStream = inputEventStream;
        this.iterableFunction = iterableFunction;
        this.streamFunctionInstance = iterableFunction.captured().length > 0 ? EventProcessorBuilderService.service().addOrReuse(iterableFunction.captured()[0]) : null;
    }

    @OnParentUpdate(value="inputEventStream")
    public void inputUpdatedAndFlatMap(S inputEventStream) {
        Object input = inputEventStream.get();
        Iterable iterable = (Iterable)this.iterableFunction.apply(input);
        this.callback.fireCallback(iterable.iterator());
        if (this.flatMapCompleteSignal != null) {
            this.getContext().getStaticEventProcessor().publishSignal(this.flatMapCompleteSignal, this.flatMapCompleteSignal);
        }
    }

    @OnTrigger
    public void callbackReceived() {
        this.value = this.callback.get();
    }

    @Override
    public void parallel() {
    }

    @Override
    public boolean parallelCandidate() {
        return false;
    }

    @Override
    public boolean hasChanged() {
        return this.dirtyStateMonitor.isDirty(this);
    }

    @Override
    public R get() {
        return this.value;
    }

    @Override
    public void setUpdateTriggerNode(Object updateTriggerNode) {
    }

    @Override
    public void setPublishTriggerNode(Object publishTriggerNode) {
    }

    @Override
    public void setResetTriggerNode(Object resetTriggerNode) {
    }

    @Override
    public void setPublishTriggerOverrideNode(Object publishTriggerOverrideNode) {
    }

    public String getFlatMapCompleteSignal() {
        return this.flatMapCompleteSignal;
    }

    public void setFlatMapCompleteSignal(String flatMapCompleteSignal) {
        this.flatMapCompleteSignal = flatMapCompleteSignal;
    }
}

