/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.function;

import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.annotations.builder.AssignToField;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.function.AbstractFlowFunction;
import com.fluxtion.runtime.partition.LambdaReflection;

public class LookupFlowFunction<R, T, S extends FlowFunction<R>, I, L>
extends AbstractFlowFunction<R, T, S> {
    private final LambdaReflection.SerializableBiFunction<R, L, T> mapFunction;
    private final LambdaReflection.SerializableFunction<I, L> lookupFunction;
    private final LambdaReflection.SerializableFunction<R, I> lookupKeyFunction;
    private T streamOutputValue;

    public LookupFlowFunction(S inputEventStream, @AssignToField(value="lookupKeyFunction") LambdaReflection.SerializableFunction<R, I> lookupKeyFunction, @AssignToField(value="lookupFunction") LambdaReflection.SerializableFunction<I, L> lookupFunction, @AssignToField(value="mapFunction") LambdaReflection.SerializableBiFunction<R, L, T> methodReferenceReflection) {
        super(inputEventStream, methodReferenceReflection);
        this.mapFunction = methodReferenceReflection;
        this.lookupKeyFunction = lookupKeyFunction;
        this.lookupFunction = lookupFunction;
    }

    @OnTrigger
    public boolean applyLookup() {
        Object streamValue = this.getInputEventStream().get();
        Object lookupKey = this.lookupKeyFunction.apply(streamValue);
        if (lookupKey != null) {
            Object lookupValue = this.lookupFunction.apply(lookupKey);
            this.streamOutputValue = this.mapFunction.apply(streamValue, lookupValue);
        }
        boolean filter = this.isPublishTriggered() || lookupKey != null;
        boolean fireNotification = filter & this.fireEventUpdateNotification();
        this.auditLog.info("foundLookupValue", filter);
        this.auditLog.info("publishToChild", fireNotification);
        return fireNotification;
    }

    @Override
    public T get() {
        return this.streamOutputValue;
    }
}

