/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.function;

import com.fluxtion.runtime.annotations.NoTriggerReference;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.annotations.PushReference;
import com.fluxtion.runtime.annotations.builder.Inject;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.function.AbstractFlowFunction;
import com.fluxtion.runtime.node.NodeNameLookup;

public class MapOnNotifyFlowFunction<R, T, S extends FlowFunction<R>>
extends AbstractFlowFunction<R, T, S> {
    @PushReference
    private final T target;
    private final transient String auditInfo;
    private String instanceNameToNotify;
    @Inject
    @NoTriggerReference
    public NodeNameLookup nodeNameLookup;

    public MapOnNotifyFlowFunction(S inputEventStream, T target) {
        super(inputEventStream, null);
        this.target = target;
        this.auditInfo = target.getClass().getSimpleName();
    }

    @Override
    protected void initialise() {
        this.instanceNameToNotify = this.nodeNameLookup.lookupInstanceName(this.target);
    }

    @OnTrigger
    public boolean notifyChild() {
        this.auditLog.info("notifyClass", this.auditInfo);
        this.auditLog.info("notifyInstance", this.instanceNameToNotify);
        return this.fireEventUpdateNotification();
    }

    @Override
    public T get() {
        return this.target;
    }

    @Override
    public String toString() {
        return "MapOnNotifyFlowFunction(target=" + this.target + ", auditInfo=" + this.auditInfo + ", instanceNameToNotify=" + this.instanceNameToNotify + ", nodeNameLookup=" + this.nodeNameLookup + ")";
    }
}

